/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.qubership.itool.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigUtils.class);
    private static volatile Properties buildProperties;

    public static String getConfigValue(String jsonPointer, JsonObject config) {
        Object value = JsonPointer.from((String)jsonPointer).queryJson((Object)config);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static boolean isFeatureEnabled(String feature, JsonObject config) {
        String value = ConfigUtils.getConfigValue("/disabledFeatures", config);
        if (value == null) {
            return true;
        }
        return !value.contains(feature);
    }

    public static Future<List<Path>> getFilesFromJsonConfig(Vertx vertx, JsonObject config, JsonPointer listPointer, String ... path) {
        return vertx.fileSystem().readFile(ConfigUtils.getConfigFilePath(config, path).toString()).map(fileContents -> {
            JsonObject json = new JsonObject(fileContents);
            List filesArray = ((JsonArray)listPointer.queryJson((Object)json)).stream().map(str -> Path.of((String)str, new String[0])).collect(Collectors.toList());
            return filesArray;
        });
    }

    public static Path getConfigFilePath(JsonObject config, String ... path) {
        Path configPath = Path.of(ConfigUtils.getConfigValue("/configPath", config), "releases", ConfigUtils.getConfigValue("/release", config));
        Path configFilePath = Path.of(configPath.toString(), path);
        if (!configFilePath.toFile().exists()) {
            configPath = Path.of(ConfigUtils.getConfigValue("/configPath", config), "default");
            configFilePath = Path.of(configPath.toString(), path);
        }
        return configFilePath;
    }

    public static Path getSuperRepoFilePath(JsonObject config, String ... path) {
        return Path.of(ConfigUtils.getConfigValue("/git/superRepositoryDir", config), path);
    }

    public static Properties getInventoryToolBuildProperties() {
        if (buildProperties != null) {
            return buildProperties;
        }
        Properties buildProps = new Properties();
        try (InputStream is = FSUtils.openUrlStream(ConfigUtils.class, "classpath:/inventory.tool.build.properties");){
            BufferedInputStream buffer = new BufferedInputStream(is, 256);
            buildProps.load(buffer);
            buildProperties = buildProps;
        }
        catch (IOException e) {
            LOG.error("Failed to read /inventory.tool.build.properties", (Throwable)e);
        }
        return buildProps;
    }

    public static String fillDomainId(String domainId) {
        return "orphans".equals(domainId) || domainId.startsWith("D_") ? domainId : "D_" + domainId;
    }

    public static String stripDomainId(String domainId) {
        return domainId.startsWith("D_") ? domainId.substring("D_".length()) : domainId;
    }
}

