/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigVariablesExtractor {
    static final Pattern VALUES_EXTRACTION_PATTERN = Pattern.compile("\\.Values\\.(\\S+)\\s*");
    static final Pattern PREPROCESSOR_EXPRESSION_PATTERN = Pattern.compile("\\{\\{(.+?)\\}\\}");

    public static Set<String> extractVariableNames(Object jsonStructure) {
        HashSet<String> collector = new HashSet<String>();
        ConfigVariablesExtractor.handleObjectContents(collector, jsonStructure);
        return collector;
    }

    private static void handleObjectContents(Set<String> collector, Object object) {
        Object structure = object;
        if (object instanceof List) {
            structure = new JsonArray((List)structure);
        } else if (object instanceof Map) {
            structure = new JsonObject((Map)object);
        } else if (object instanceof String) {
            ConfigVariablesExtractor.handleStringValue(collector, (String)object);
            return;
        }
        if (structure instanceof JsonObject) {
            ConfigVariablesExtractor.handleJsonObjectFields(collector, (JsonObject)structure);
        } else if (structure instanceof JsonArray) {
            ConfigVariablesExtractor.handleJsonArrayItems(collector, (JsonArray)structure);
        }
    }

    private static void handleJsonArrayItems(Set<String> collector, JsonArray jsonArrayStructure) {
        for (Object element : jsonArrayStructure) {
            ConfigVariablesExtractor.handleObjectContents(collector, element);
        }
    }

    private static void handleJsonObjectFields(Set<String> collector, JsonObject jsonObjectStructure) {
        for (Map.Entry element : jsonObjectStructure) {
            ConfigVariablesExtractor.handleObjectContents(collector, element.getValue());
        }
    }

    private static void handleStringValue(Set<String> collector, String value) {
        if (value == null || !value.contains(".Values.")) {
            return;
        }
        ConfigVariablesExtractor.getVariableNames(collector, ConfigVariablesExtractor.getValuesByPattern(value, PREPROCESSOR_EXPRESSION_PATTERN));
    }

    private static void getVariableNames(Set<String> collector, Set<String> preprocessorExpressions) {
        for (String expression : preprocessorExpressions) {
            collector.addAll(ConfigVariablesExtractor.getValuesByPattern(expression, VALUES_EXTRACTION_PATTERN));
        }
    }

    private static Set<String> getValuesByPattern(String sourceString, Pattern pattern) {
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = pattern.matcher(sourceString);
        while (matcher.find()) {
            result.add(matcher.group(1));
        }
        return result;
    }
}

