/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FutureUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FutureUtils.class);

    public static <T> T blockForResultOrException(Future<T> future) {
        return FutureUtils.getResultOrException(FutureUtils.blockForAsyncResult(future));
    }

    public static <T> T blockForResultOrException(Future<T> future, long timeout, TimeUnit timeUnit) {
        return FutureUtils.getResultOrException(FutureUtils.blockForAsyncResult(future, timeout, timeUnit));
    }

    public static <T> AsyncResult<T> blockForAsyncResult(Future<T> future) {
        if (future.isComplete()) {
            return future;
        }
        ArrayBlockingQueue resultPipe = new ArrayBlockingQueue(1);
        future.onComplete(ar -> resultPipe.offer(ar));
        try {
            return (AsyncResult)resultPipe.take();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return Future.failedFuture((Throwable)e);
        }
    }

    public static <T> AsyncResult<T> blockForAsyncResult(Future<T> future, long timeout, TimeUnit timeUnit) {
        if (future.isComplete()) {
            return future;
        }
        ArrayBlockingQueue resultPipe = new ArrayBlockingQueue(1);
        future.onComplete(ar -> resultPipe.offer(ar));
        try {
            return (AsyncResult)resultPipe.poll(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static <T> T getResultOrException(AsyncResult<T> ar) {
        if (ar == null) {
            return null;
        }
        if (ar.failed()) {
            Throwable cause = ar.cause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        return (T)ar.result();
    }

    public static <T> Optional<T> anyResult(List<Future<T>> futuresList) {
        return futuresList.stream().filter(Future::succeeded).findAny().map(Future::result);
    }

    public static Optional<Throwable> anyCause(List<Future> futuresList) {
        return futuresList.stream().filter(Future::failed).findAny().map(Future::cause);
    }

    public static <T> Future<T> anyFuture(List<Future<T>> futures) {
        if (futures.isEmpty()) {
            return Future.succeededFuture();
        }
        if (futures.size() == 1) {
            return futures.get(0);
        }
        return CompositeFuture.any(futures).flatMap(cf -> {
            if (cf.succeeded()) {
                return Future.succeededFuture(FutureUtils.anyResult(futures).get());
            }
            List list = futures;
            return Future.failedFuture((Throwable)FutureUtils.anyCause(list).get());
        });
    }

    public static <T> List<T> invokeAndJoin(final List<RecursiveTask<T>> tasks, ForkJoinPool pool) {
        if (tasks.isEmpty()) {
            return Collections.emptyList();
        }
        RecursiveTask composite = new RecursiveTask<List<T>>(){

            @Override
            protected List<T> compute() {
                for (RecursiveTask subtask : tasks) {
                    subtask.fork();
                }
                return tasks.stream().map(ForkJoinTask::join).collect(Collectors.toList());
            }
        };
        return (List)pool.invoke(composite);
    }

    public static <T> List<T> invokeAndJoin(List<RecursiveTask<T>> tasks) {
        return FutureUtils.invokeAndJoin(tasks, ForkJoinPool.commonPool());
    }
}

