/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import org.qubership.itool.utils.ConfigUtils;
import org.qubership.itool.utils.FSUtils;

public class GitUtils {
    public static String buildRepositoryLink(JsonObject component, String fileName, JsonObject config) {
        String relativePath = FSUtils.relativePath(component, fileName);
        return GitUtils.buildRepositoryLinkRelative(component, relativePath, config);
    }

    public static String buildRepositoryLinkRelative(JsonObject component, String relativePath, JsonObject config) {
        String repositoryLink = component.getString("repository").replaceAll("^(\\S+).git$", "$1");
        String branchFromComponent = (String)JsonPointer.from((String)"/details/releaseBranch").queryJson((Object)component);
        if (branchFromComponent == null) {
            branchFromComponent = ConfigUtils.getConfigValue("/git/releaseBranch", config);
        }
        String branch = "/-/blob/" + branchFromComponent + "/";
        Object subDir = component.getString("repositorySubDir", "");
        if (!((String)subDir).isEmpty()) {
            subDir = (String)subDir + "/";
        }
        return repositoryLink + branch + (String)subDir + relativePath;
    }
}

