/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphDataConstants;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.qubership.itool.utils.XmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LanguageUtils {
    public static final JsonPointer LANGUAGE_PATH_POINTER = JsonPointer.from((String)"/details/language");
    private static final XPathFactory xPathfactory = XPathFactory.newInstance();
    private static final XPath xpath = xPathfactory.newXPath();
    private static final List<String> USAGES_LIST = List.of("source", "target", "release");
    public static final String JAVA_LANGUAGE_NAME = "Java";
    private static final String F_LANGUAGE_NAME = "name";
    private static final String F_LANGUAGE_VERSION = "version";
    private static final String F_LANGUAGE_USAGE = "usage";

    public static JsonArray convertListToLanguages(Object value) {
        JsonArray languages = new JsonArray();
        if (value instanceof JsonArray) {
            value = ((JsonArray)value).getList();
        } else if (value instanceof String) {
            value = List.of(((String)((Object)value)).split("\\s*,\\s*"));
        }
        if (value instanceof List) {
            ((List)value).stream().map(String::valueOf).filter(s -> !GraphDataConstants.NOS_TO_RECOGNIZE.contains(s)).map(TechNormalizationHelper::normalizeTechAsJson).filter(Objects::nonNull).forEach(arg_0 -> ((JsonArray)languages).add(arg_0));
        }
        return languages;
    }

    public static boolean hasLanguage(BasicGraph graph, JsonObject component, String languageName) {
        return graph.traversal().V(component.getString("id")).out("info").hasType("language").has(F_LANGUAGE_NAME, languageName).next() != null;
    }

    public static String getLanguagesAsString(BasicGraph graph, JsonObject component) {
        List languages = graph.traversal().V(component.getString("id")).out("info").hasType("language").values(F_LANGUAGE_NAME, F_LANGUAGE_VERSION).toList();
        return languages.stream().map(lng -> {
            String version = (String)lng.get(F_LANGUAGE_VERSION);
            if (version == null) {
                return (String)lng.get(F_LANGUAGE_NAME);
            }
            return (String)lng.get(F_LANGUAGE_NAME) + " " + version;
        }).collect(Collectors.joining(", "));
    }

    public static void updateDetailsLanguagesUsingPomFile(Graph graph, JsonObject component) {
        String pomFileContents = (String)graph.traversal().V(component.getString("id")).out(new String[0]).glob("pom.xml").value("content").next();
        if (pomFileContents == null) {
            return;
        }
        try {
            Document document = XmlParser.parseXmlString(pomFileContents, "pom.xml");
            Map<String, String> properties = LanguageUtils.extractProperties(document);
            NodeList mavenCompilerPlugin = LanguageUtils.findMavenCompilerPlugin(document);
            HashMap<String, String> javaUsageVersions = new HashMap<String, String>();
            for (String languageUsage : USAGES_LIST) {
                String version2 = LanguageUtils.getVersion(mavenCompilerPlugin, properties, languageUsage);
                if (StringUtils.isEmpty((CharSequence)version2)) continue;
                javaUsageVersions.put(languageUsage, version2);
            }
            String javaVersion = (String)ObjectUtils.firstNonNull((Object[])javaUsageVersions.values().toArray(new String[0]));
            if (javaVersion != null) {
                Object versionsObj = LANGUAGE_PATH_POINTER.queryJson((Object)component);
                List versions = JsonUtils.asList(versionsObj);
                if (versions == null) {
                    versions = new ArrayList();
                }
                List<Object> languageVersions = versions;
                for (String javaUsage : javaUsageVersions.keySet()) {
                    AtomicBoolean versionFound = new AtomicBoolean(false);
                    languageVersions = languageVersions.stream().map(version -> LanguageUtils.updateJavaVersions(javaUsage, version, (String)javaUsageVersions.get(javaUsage), versionFound)).collect(Collectors.toList());
                    if (versionFound.get()) continue;
                    languageVersions.add(new JsonObject().put(F_LANGUAGE_NAME, (Object)JAVA_LANGUAGE_NAME).put(F_LANGUAGE_VERSION, (Object)javaVersion).put(F_LANGUAGE_USAGE, (Object)new JsonArray().add((Object)javaUsage)));
                }
                LANGUAGE_PATH_POINTER.writeJson((Object)component, (Object)new JsonArray(languageVersions), true);
            }
        }
        catch (Exception e) {
            graph.getReport().exceptionThrown(component, e);
        }
    }

    private static NodeList findMavenCompilerPlugin(Document document) throws XPathExpressionException {
        NodeList mavenCompilerPlugin = (NodeList)xpath.compile("/project/build/pluginManagement/plugins/plugin[artifactId='maven-compiler-plugin']").evaluate(document, XPathConstants.NODESET);
        if (mavenCompilerPlugin != null && mavenCompilerPlugin.getLength() > 0) {
            return mavenCompilerPlugin;
        }
        return (NodeList)xpath.compile("/project/build/plugins/plugin[artifactId='maven-compiler-plugin']").evaluate(document, XPathConstants.NODESET);
    }

    private static JsonObject updateJavaVersions(String javaUsage, JsonObject version, String javaUsageVersion, AtomicBoolean versionFound) {
        if (JAVA_LANGUAGE_NAME.equals(version.getString(F_LANGUAGE_NAME))) {
            String languageVersion = version.getString(F_LANGUAGE_VERSION);
            if (languageVersion == null) {
                version.put(F_LANGUAGE_VERSION, (Object)javaUsageVersion);
                version.put(F_LANGUAGE_USAGE, (Object)new JsonArray().add((Object)javaUsage));
                versionFound.set(true);
            } else if (languageVersion.equals(javaUsageVersion)) {
                LanguageUtils.updateVersionUsage(javaUsage, version);
                versionFound.set(true);
            }
        }
        return version;
    }

    public static void updateVersionUsage(String newUsage, JsonObject version) {
        JsonArray usage = version.getJsonArray(F_LANGUAGE_USAGE);
        if (usage == null) {
            usage = new JsonArray();
        }
        if (usage.contains((Object)newUsage)) {
            return;
        }
        usage.add((Object)newUsage);
        version.put(F_LANGUAGE_USAGE, (Object)usage);
    }

    private static String getVersion(NodeList mavenCompilerPlugin, Map<String, String> properties, String versionType) throws Exception {
        String version = properties.get("maven.compiler." + versionType);
        if ((version = LanguageUtils.getValueFromVariable(properties, version)) != null) {
            return version;
        }
        if (mavenCompilerPlugin != null && mavenCompilerPlugin.getLength() > 0) {
            version = (String)xpath.compile("configuration/" + versionType).evaluate(mavenCompilerPlugin.item(0), XPathConstants.STRING);
            version = LanguageUtils.getValueFromVariable(properties, version);
        }
        if (version != null) {
            return version;
        }
        return properties.get("java.version");
    }

    private static String getValueFromVariable(Map<String, String> properties, String version) {
        if (version != null && version.startsWith("${")) {
            String varName = LanguageUtils.extractPlaceholderName(version);
            version = properties.get(varName);
        }
        return version;
    }

    private static String extractPlaceholderName(String str) {
        return str.substring(2, str.length() - 1);
    }

    private static Map<String, String> extractProperties(Document document) throws Exception {
        NodeList props = (NodeList)xpath.compile("/project/properties/*").evaluate(document, XPathConstants.NODESET);
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>(props.getLength());
        for (int i = 0; i < props.getLength(); ++i) {
            Element item = (Element)props.item(i);
            String key = item.getTagName();
            Node child0 = item.getChildNodes().item(0);
            if (!(child0 instanceof Text)) continue;
            String value = ((Text)child0).getWholeText();
            properties.put(key, value);
        }
        return properties;
    }

    public static void buildLanguageVerticesWithEdges(Graph graph, JsonObject component) {
        Object languageProperty = LANGUAGE_PATH_POINTER.queryJson((Object)component);
        if (languageProperty == null) {
            return;
        }
        List<JsonObject> languageProperties = JsonUtils.asList(languageProperty);
        for (JsonObject language : languageProperties) {
            String languageVersion;
            String languageName = language.getString(F_LANGUAGE_NAME);
            String languageId = languageName + (String)((languageVersion = language.getString(F_LANGUAGE_VERSION)) != null ? " " + languageVersion : "");
            JsonObject languageVertex = graph.getVertex(languageId);
            if (languageVertex == null) {
                languageVertex = new JsonObject().put("id", (Object)languageId).put("type", (Object)"language").put(F_LANGUAGE_NAME, (Object)languageName);
                if (languageVersion != null) {
                    languageVertex.put(F_LANGUAGE_VERSION, (Object)languageVersion);
                }
                graph.addVertex("Info", languageVertex);
            }
            JsonObject languageEdge = new JsonObject().put("type", (Object)"info");
            JsonArray languageUsages = language.getJsonArray(F_LANGUAGE_USAGE);
            if (languageUsages != null) {
                languageEdge.put(F_LANGUAGE_USAGE, (Object)languageUsages);
            }
            graph.addEdge(component, languageVertex, languageEdge);
        }
    }
}

