/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.utils.JsonUtils;

public class TechNormalizationHelper {
    private static final String NORMALIZATION_RESOURCE_PATH = "classpath:/normalizationConfig.json";
    private static final Map<String, Pattern> techNamesMap = TechNormalizationHelper.buildTechNamesMap();

    private static Map<String, Pattern> buildTechNamesMap() {
        JsonObject techList = null;
        try {
            techList = JsonUtils.readJsonResource(TechNormalizationHelper.class, NORMALIZATION_RESOURCE_PATH, JsonObject.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LinkedHashMap<String, Pattern> result = new LinkedHashMap<String, Pattern>();
        for (Map.Entry t : techList) {
            result.put((String)t.getKey(), StringUtils.isNotEmpty((CharSequence)((String)t.getValue())) ? Pattern.compile((String)t.getValue(), 2) : Pattern.compile("^" + (String)t.getKey() + "(?:\\s+(.+))?$", 2));
        }
        return Collections.unmodifiableMap(result);
    }

    public static Map<String, Pattern> getTechNamesMap() {
        return techNamesMap;
    }

    public static List<String> normalizeTechs(List<String> techNames) {
        return techNames.stream().map(TechNormalizationHelper::normalizeTechWithVersion).collect(Collectors.toList());
    }

    public static Optional<String> normalizeTech(String tech) {
        if (tech == null) {
            return Optional.empty();
        }
        return techNamesMap.entrySet().stream().filter(entry -> ((Pattern)entry.getValue()).matcher(tech).matches()).map(Map.Entry::getKey).findFirst();
    }

    public static List<String> getTechsNames(List<String> techEntries) {
        return techEntries.stream().map(tech -> TechNormalizationHelper.normalizeTech(tech).orElse((String)tech)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String normalizeTechWithVersion(String tech) {
        if (StringUtils.isEmpty((CharSequence)tech)) {
            return tech;
        }
        if (techNamesMap.containsKey(tech)) {
            return tech;
        }
        Optional<String> matchedTech = techNamesMap.entrySet().stream().map(entry -> {
            Matcher matcher = ((Pattern)entry.getValue()).matcher(tech);
            if (matcher.matches()) {
                String version = matcher.group(1);
                return (String)entry.getKey() + (String)(version != null ? " " + version : "");
            }
            return null;
        }).filter(Objects::nonNull).findFirst();
        return matchedTech.orElse(tech);
    }

    public static JsonObject normalizeTechAsJson(String tech) {
        if (StringUtils.isBlank((CharSequence)tech)) {
            return null;
        }
        if (techNamesMap.containsKey(tech)) {
            return new JsonObject().put("name", (Object)tech);
        }
        String normalizedTech = TechNormalizationHelper.normalizeTechWithVersion(tech);
        String[] nameVersion = normalizedTech.split("\\s+", 3);
        JsonObject result = new JsonObject().put("name", (Object)nameVersion[0]);
        if (nameVersion.length > 1) {
            result.put("version", (Object)nameVersion[1]);
        }
        return result;
    }
}

