/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.Streams;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.qubership.itool.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlParser {
    protected static final Logger LOG = LoggerFactory.getLogger(YamlParser.class);
    protected static final Pattern BRACE_PROTECTOR_KEY = Pattern.compile("^(\\s*[^-:][^:]*:[^\\'\\\"{]*)(\\{\\s*\\{.*)([^\\'\\\"\\s])\\s*$");
    protected static final String BRACE_PROTECTOR_KEY_REPLACEMENT = "$1'$2$3'";
    protected static final Pattern BRACE_PROTECTOR_DASH = Pattern.compile("^(\\s*-[^\\'\\\"{]*)(\\{\\s*\\{.*)([^\\'\\\"\\s])\\s*$");
    protected static final String BRACE_PROTECTOR_DASH_REPLACEMENT = "$1'$2$3'";
    protected static final Pattern AT_PROTECTOR = Pattern.compile("(^|[^\\'\\\"])(@[^\\s@]+@)([^\\'\\\"]|$)");
    protected static final String AT_PROTECTOR_REPLACEMENT = "$1'$2'$3";
    protected static final Pattern SPRING_SUBST_PROTECTOR_KEY = Pattern.compile("^(\\s*[^-:][^:]*:[^\\'\\\"${]*)(\\$\\{.*)([^\\'\\\"\\s])\\s*$");
    protected static final YAMLFactory defaultYamlFactory = new YAMLFactory();
    protected static final ObjectMapper defaultMapper = new ObjectMapper((JsonFactory)defaultYamlFactory).findAndRegisterModules();
    boolean logNormalizedData = true;

    public void setLogNormalizedData(boolean logNormalizedData) {
        this.logNormalizedData = logNormalizedData;
    }

    public List<Object> parseYaml(File file) throws IOException, JsonParseException {
        try (FileReader reader = new FileReader(file, JsonUtils.UTF_8);){
            List<Object> list = this.parseYaml(reader, file.getAbsolutePath());
            return list;
        }
    }

    public List<Object> parseYamlData(String yaml, String sourceId) throws IOException, JsonParseException {
        return this.parseYaml(new StringReader(yaml), sourceId);
    }

    public List<Object> parseYaml(Reader reader, String sourceId) throws IOException, JsonParseException {
        List<Object> list;
        String normalizedData = null;
        LineNumberReader lnr = new LineNumberReader(reader);
        try {
            normalizedData = lnr.lines().filter(s -> this.acceptLine((String)s)).map(s -> this.normalizeLine((String)s)).collect(Collectors.joining("\n", "", "\n"));
            list = this.parseSafeYaml(new StringReader(normalizedData), sourceId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    lnr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | RuntimeException e) {
                if (this.logNormalizedData) {
                    LOG.warn("Normalized data:\n{}", (Object)sourceId, normalizedData);
                }
                throw e;
            }
        }
        lnr.close();
        return list;
    }

    public List<Object> parseSafeYaml(Reader reader, String sourceId) throws IOException, JsonParseException {
        try {
            MappingIterator values = this.getMapper().readValues(this.getJsonFactory().createParser(reader), JsonNode.class);
            List<Object> subDocuments = Streams.stream((Iterator)values).map(this::nodeToValue).collect(Collectors.toList());
            return subDocuments;
        }
        catch (IOException | RuntimeException e) {
            LOG.warn("Failed to parse YAML from {}", (Object)sourceId);
            throw e;
        }
    }

    protected boolean acceptLine(String s) {
        String trimmed = s.trim();
        return !trimmed.startsWith("{{") && !trimmed.startsWith("{ {");
    }

    protected String normalizeLine(String s) {
        Object s1 = BRACE_PROTECTOR_KEY.matcher(s).replaceFirst("$1'$2$3'");
        if (!((String)s1).equals(s)) {
            return s1;
        }
        s1 = BRACE_PROTECTOR_DASH.matcher(s).replaceFirst("$1'$2$3'");
        if (!((String)s1).equals(s)) {
            return s1;
        }
        s1 = AT_PROTECTOR.matcher(s).replaceAll(AT_PROTECTOR_REPLACEMENT);
        if (!((String)s1).equals(s)) {
            return s1;
        }
        Matcher m = SPRING_SUBST_PROTECTOR_KEY.matcher(s);
        if (m.find()) {
            s1 = m.group(1) + "'" + m.group(2).replace("'", "_") + m.group(3) + "'";
        }
        return s1;
    }

    protected ObjectMapper getMapper() {
        return defaultMapper;
    }

    private JsonFactory getJsonFactory() {
        return defaultYamlFactory;
    }

    protected Object nodeToValue(JsonNode node) {
        try {
            return this.getMapper().treeToValue((TreeNode)node, Object.class);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public void fixSpringYamlModel(Object obj) {
        if (obj instanceof List) {
            this.fixSpringYamlModels((List)obj);
        } else if (obj instanceof JsonArray) {
            this.fixSpringYamlModels((JsonArray)obj);
        } else if (obj instanceof Map) {
            this.fixSpringYamlModel(new JsonObject((Map)obj));
        } else if (obj instanceof JsonObject) {
            this.fixSpringYamlModel((JsonObject)obj);
        }
    }

    public void fixSpringYamlModels(List<?> list) {
        this.fixSpringYamlModel(new JsonArray(list));
    }

    public void fixSpringYamlModels(JsonArray list) {
        for (Object obj : list) {
            this.fixSpringYamlModel(obj);
        }
    }

    public void fixSpringYamlModel(JsonObject obj) {
        LinkedHashSet<String> keysToFix = null;
        for (Map.Entry e : obj) {
            String key = (String)e.getKey();
            if (key.indexOf(46) < 0) continue;
            if (keysToFix == null) {
                keysToFix = new LinkedHashSet<String>();
            }
            keysToFix.add(key);
        }
        if (keysToFix != null) {
            for (String key : keysToFix) {
                Object value = obj.remove(key);
                JsonPointer ptr = JsonPointer.from((String)("/" + key.replace('.', '/')));
                Object oldValue = ptr.queryJson((Object)obj);
                if (oldValue instanceof JsonObject && value instanceof JsonObject) {
                    ((JsonObject)oldValue).getMap().putAll(((JsonObject)value).getMap());
                    continue;
                }
                if (oldValue != null) {
                    LOG.warn("Overwriting key {}: old={}, new={}", new Object[]{key, oldValue, value});
                }
                ptr.writeJson((Object)obj, value, true);
            }
        }
        for (Map.Entry e : obj) {
            this.fixSpringYamlModel(e.getValue());
        }
    }
}

