/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.qubership.itool.cli.ApplicationContextHolder;
import org.qubership.itool.cli.FlowMainVerticle;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.di.ApplicationContext;
import org.qubership.itool.modules.graph.GraphService;
import org.qubership.itool.utils.FutureUtils;
import org.slf4j.Logger;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    protected Map<String, String> properties = new HashMap<String, String>(Map.of("/profile", "dev", "/configPath", "inventory-tool"));

    protected abstract Logger getLogger();

    public void runFlow(FlowMainVerticle main, GraphService graphService) {
        Vertx vertx = Vertx.vertx();
        vertx.exceptionHandler(err -> {
            this.getLogger().error("Critical error, application is stopping", err);
            System.exit(1);
        });
        Future flowFuture = this.runFlow(vertx, main, graphService).onComplete(ar -> {
            if (ar.failed()) {
                this.getLogger().error("Flow execution failed", ar.cause());
                System.exit(1);
            }
            System.exit(0);
        });
        FutureUtils.blockForResultOrException(flowFuture, 10L, TimeUnit.HOURS);
    }

    protected Future<?> runFlow(Vertx vertx, FlowMainVerticle main, GraphService graphService) {
        return Future.future(promise -> {
            try {
                ApplicationContext context = this.getSharedApplicationContext();
                if (context == null) {
                    throw new IllegalStateException("Shared application context is not available. This indicates a problem with the execution strategy.");
                }
                FlowContext flowContext = context.getInstance(FlowContext.class);
                main.deployAndRunFlow(flowContext).onComplete(flowResult -> {
                    promise.handle(flowResult);
                    this.flowFinished(main, (AsyncResult<?>)flowResult);
                });
            }
            catch (Throwable ex) {
                promise.fail(ex);
            }
        });
    }

    private ApplicationContext getSharedApplicationContext() {
        ApplicationContext context = ApplicationContextHolder.getInstance();
        if (context == null) {
            throw new IllegalStateException("No application context available. Ensure InventoryToolMain properly initialized the shared context.");
        }
        return context;
    }

    protected void flowFinished(FlowMainVerticle main, AsyncResult<?> flowResult) {
        main.undeploy();
        if (flowResult.succeeded()) {
            this.getLogger().info("Flow succeeded. Undeploying and terminating.");
        } else {
            this.getLogger().error("Flow failed. Undeploying and terminating.", flowResult.cause());
        }
    }

    @CommandLine.Option(names={"--set"}, description={"Universal setter: name=value (multiple)"}, required=false)
    public void setProperty(String[] params) {
        for (String param : params) {
            String[] pair = param.split("=", 2);
            this.properties.put(pair[0], pair.length > 1 ? pair[1] : "");
        }
    }

    @CommandLine.Option(names={"-c", "--configPath"}, description={"Path to folder containing the configuration files"}, required=false)
    public void setConfigPath(String configPath) {
        this.properties.put("/configPath", configPath);
    }

    @CommandLine.Option(names={"-p", "--profile"}, description={"Custom profile to be used. By default uses properties format, in case of json, use file name with extension (Examples: \"custom\", \"custom.properties\", \"custom_example.json\")"}, required=false)
    public void setProfile(String profile) {
        this.properties.put("/profile", profile);
    }
}

