/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VerticleFactory;
import java.util.Optional;
import java.util.ServiceLoader;
import org.qubership.itool.cli.spi.ModuleProvider;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.di.ApplicationContext;
import org.qubership.itool.di.QubershipModule;
import org.qubership.itool.factories.JavaAppContextVerticleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationContextHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationContextHolder.class);
    private static volatile ApplicationContext instance;
    private static volatile FlowContext flowContext;

    public static void initializeWithConfig(Vertx vertx, JsonObject config) {
        if (instance != null) {
            ApplicationContextHolder.clear();
        }
        instance = new ApplicationContext(vertx, config, ApplicationContextHolder.createModules(vertx));
        flowContext = instance.getInstance(FlowContext.class);
        ApplicationContextHolder.initializeVerticleFactories(vertx, flowContext, config);
        LOGGER.debug("Application context initialized with command-specific config");
    }

    public static ApplicationContext getInstance() {
        return instance;
    }

    public static FlowContext getFlowContext() {
        return flowContext;
    }

    public static void clear() {
        instance = null;
        flowContext = null;
    }

    private static Module[] createModules(Vertx vertx) {
        QubershipModule baseModule = new QubershipModule(vertx);
        Module extensionModule = ApplicationContextHolder.discoverExtensionModule(vertx);
        if (extensionModule != null) {
            return new Module[]{Modules.override((Module[])new Module[]{baseModule}).with(new Module[]{extensionModule})};
        }
        return new Module[]{baseModule};
    }

    private static Module discoverExtensionModule(Vertx vertx) {
        try {
            ServiceLoader<ModuleProvider> serviceLoader = ServiceLoader.load(ModuleProvider.class);
            ModuleProvider selectedProvider = null;
            for (ModuleProvider provider : serviceLoader) {
                if (selectedProvider == null) {
                    selectedProvider = provider;
                    LOGGER.info("Using extension module provider: {}", (Object)provider.getName());
                    continue;
                }
                LOGGER.warn("Ignoring additional module provider: {}. Only one extension module is supported.", (Object)provider.getName());
            }
            if (selectedProvider != null) {
                Module module = selectedProvider.createModule(vertx);
                if (module != null) {
                    LOGGER.debug("Created extension module from provider: {}", (Object)selectedProvider.getName());
                    return module;
                }
                LOGGER.debug("Provider {} returned null module", (Object)selectedProvider.getName());
            } else {
                LOGGER.debug("No extension module providers found");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to discover extension module", (Throwable)e);
        }
        return null;
    }

    private static void initializeVerticleFactories(Vertx vertx, FlowContext flowContext, JsonObject config) {
        JavaAppContextVerticleFactory javaTaskFactory;
        Optional<VerticleFactory> factory = vertx.verticleFactories().stream().filter(f -> f instanceof JavaAppContextVerticleFactory).findAny();
        if (factory.isEmpty()) {
            javaTaskFactory = new JavaAppContextVerticleFactory(flowContext, config);
            vertx.registerVerticleFactory((VerticleFactory)javaTaskFactory);
        } else {
            javaTaskFactory = (JavaAppContextVerticleFactory)factory.get();
        }
        flowContext.initialize(vertx, config);
        flowContext.setTaskClassLoader(javaTaskFactory.getTaskClassLoader());
    }
}

