/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.ApplicationContextHolder;
import org.qubership.itool.cli.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class ConfigLoadingExecutionStrategy
implements CommandLine.IExecutionStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigLoadingExecutionStrategy.class);
    private final Vertx vertx;

    public ConfigLoadingExecutionStrategy(Vertx vertx) {
        this.vertx = vertx;
    }

    private Future<JsonObject> loadConfiguration(Map<String, String> properties) {
        if (this.vertx == null) {
            throw new IllegalStateException("Vertx instance not initialized");
        }
        return Future.future(promise -> {
            ConfigProvider configProvider = new ConfigProvider(properties, this.vertx);
            configProvider.handleConfig((Handler<AsyncResult<JsonObject>>)((Handler)arg_0 -> ((Promise)promise).handle(arg_0)));
        });
    }

    public int execute(CommandLine.ParseResult parseResult) {
        CommandLine.ParseResult subcommandParseResult;
        Object command;
        if (parseResult.hasSubcommand() && (command = (subcommandParseResult = parseResult.subcommand()).commandSpec().userObject()) instanceof AbstractCommand) {
            AbstractCommand abstractCommand = (AbstractCommand)command;
            try {
                LOGGER.debug("Initializing context with configuration for command: {}", (Object)command.getClass().getSimpleName());
                Future<JsonObject> configFuture = this.loadConfiguration(abstractCommand.properties);
                JsonObject config = (JsonObject)configFuture.toCompletionStage().toCompletableFuture().get();
                ApplicationContextHolder.initializeWithConfig(this.vertx, config);
                LOGGER.debug("Context initialized successfully for command: {}", (Object)command.getClass().getSimpleName());
            }
            catch (IllegalStateException e) {
                LOGGER.error("Vertx not initialized: {}", (Object)e.getMessage());
                return 2;
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof TimeoutException) {
                    LOGGER.error("Configuration loading timed out: {}", (Object)e.getMessage());
                    return 3;
                }
                LOGGER.error("Configuration loading failed: {}", (Object)e.getMessage(), (Object)e);
                return 4;
            }
            catch (InterruptedException e) {
                LOGGER.error("Configuration loading was interrupted: {}", (Object)e.getMessage());
                Thread.currentThread().interrupt();
                return 5;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error during context initialization: {}", (Object)e.getMessage(), (Object)e);
                return 6;
            }
        }
        try {
            return new CommandLine.RunLast().execute(parseResult);
        }
        catch (Exception e) {
            LOGGER.error("Command execution failed", (Throwable)e);
            return 1;
        }
    }
}

