/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.ExecVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="exec", description={"Execute inventory-tool"}, mixinStandardHelpOptions=true)
public class ExecCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecCommand.class);

    @CommandLine.Option(names={"-l", "--login"}, description={"Login to access services requiring authentication"})
    public void setLogin(String login) {
        this.properties.put("login", login);
    }

    @CommandLine.Option(names={"-e", "--excelExport"}, description={"Path pattern for excel report export"})
    public void setExcelExport(String excelExport) {
        this.properties.put("excelExport", excelExport);
    }

    @CommandLine.Option(names={"-u", "--uploadConfluencePages"}, description={"List of the page titles to be uploaded to Confluence. Delimiter is ','. Examples: all; none; type:report; \"Tech of DOMAIN1, Cloud Libraries list\""})
    public void setUploadConfluencePages(String uploadConfluencePages) {
        this.properties.put("/confluence/uploadConfluencePages", uploadConfluencePages);
    }

    @CommandLine.Option(names={"-sp", "--saveProgress"}, description={"Save execution progress. That allow restart progress from the specified step."})
    public void setSaveProgress(String saveProgress) {
        this.properties.put("saveProgress", saveProgress);
    }

    @CommandLine.Option(names={"-ss", "--startStep"}, description={"Start execution from the specified step if progress was saved before. See 'saveProgress' property."})
    public void setStartStep(String startStep) {
        this.properties.put("startStep", startStep);
    }

    @CommandLine.Option(names={"-ls", "--lastStep"}, description={"Last execution step (if progress was saved before). See 'saveProgress' property."})
    public void setLastStep(String lastStep) {
        this.properties.put("lastStep", lastStep);
    }

    @CommandLine.Option(names={"-id", "--includeDomains"}, description={"List of Domains that must be processed. Delimiter is ','"})
    public void setIncludeDomains(String includeDomains) {
        this.properties.put("includeDomains", includeDomains);
    }

    @CommandLine.Option(names={"-df", "--disabledFeatures"}, description={"List of the disabled features. Delimiter is ','. Examples: confluenceGenerate,confluenceUpload,excelExport,mavenDependency,repositoryUpdate"})
    public void setDisabledFeatures(String disabledFeatures) {
        this.properties.put("disabledFeatures", disabledFeatures);
    }

    @CommandLine.Option(names={"-r", "--release"}, description={"Release version to be used as a suffix during the export to Confluence"})
    public void setRelease(String release) {
        this.properties.put("/release", release);
    }

    @CommandLine.Option(names={"-rb", "--releaseBranch"}, description={"Release version to be used as a suffix during the export to Confluence"})
    public void setReleaseBranch(String releaseBranch) {
        this.properties.put("/git/releaseBranch", releaseBranch);
    }

    @CommandLine.Option(names={"-pr", "--priorRelease"}, description={"Release version prior to selected release to compare to"})
    public void setPriorRelease(String priorRelease) {
        this.properties.put("/priorRelease", priorRelease);
    }

    @CommandLine.Option(names={"-pws", "--passwordSource"}, description={"Password source, e.g.: \"file:password.txt\""})
    public void setPasswordSource(String passwordSource) {
        this.properties.put("passwordSource", passwordSource);
    }

    @CommandLine.Option(names={"--offline"}, description={"Offline mode: true/false"})
    public void setOfflineMode(String offlineMode) {
        this.properties.put("offlineMode", offlineMode);
    }

    @Override
    public Integer call() throws Exception {
        LOGGER.info("Inventory tool main flow execution");
        this.runFlow(new ExecVerticle(), null);
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

