/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import io.vertx.core.Vertx;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import org.qubership.itool.cli.ApplicationContextHolder;
import org.qubership.itool.cli.ConfigLoadingExecutionStrategy;
import org.qubership.itool.cli.spi.CommandProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="inventory-tool", description={"Inventory tool CLI application"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class InventoryToolMain
implements Callable<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InventoryToolMain.class);
    private CommandLine commandLine;
    private static Vertx sharedVertx;

    public static void main(String[] args) {
        LOGGER.info("=== Inventory Tool CLI ===");
        sharedVertx = Vertx.vertx();
        try {
            InventoryToolMain app = new InventoryToolMain();
            CommandLine commandLine = new CommandLine((Object)app);
            InventoryToolMain.loadExtensionCommands(commandLine);
            app.commandLine = commandLine;
            commandLine.setExecutionStrategy((CommandLine.IExecutionStrategy)new ConfigLoadingExecutionStrategy(sharedVertx));
            int exitCode = commandLine.execute(args);
            InventoryToolMain.cleanupSharedResources();
            System.exit(exitCode);
        }
        catch (Exception e) {
            LOGGER.error("Application failed", (Throwable)e);
            InventoryToolMain.cleanupSharedResources();
            System.exit(1);
        }
    }

    private static void cleanupSharedResources() {
        if (sharedVertx != null) {
            sharedVertx.close();
        }
        ApplicationContextHolder.clear();
    }

    @Override
    public Integer call() throws Exception {
        if (this.commandLine != null) {
            this.commandLine.usage(System.out);
        } else {
            CommandLine.usage((Object)this, (PrintStream)System.out);
        }
        return 0;
    }

    private static void loadExtensionCommands(CommandLine commandLine) {
        LOGGER.debug("Loading commands via SPI...");
        try {
            ServiceLoader<CommandProvider> commandProviders = ServiceLoader.load(CommandProvider.class);
            int commandCount = 0;
            for (CommandProvider provider : commandProviders) {
                try {
                    String commandName = provider.getCommandName();
                    Callable<Integer> command = provider.createCommand();
                    LOGGER.debug("Found command: {}", (Object)commandName);
                    CommandLine subCommandLine = new CommandLine(command);
                    subCommandLine.setOptionsCaseInsensitive(true);
                    subCommandLine.setAbbreviatedOptionsAllowed(true);
                    subCommandLine.setSubcommandsCaseInsensitive(true);
                    subCommandLine.setAbbreviatedSubcommandsAllowed(true);
                    commandLine.addSubcommand(commandName, (Object)subCommandLine);
                    ++commandCount;
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to load command from provider: {}", (Object)provider.getClass().getName(), (Object)e);
                }
            }
            if (commandCount > 0) {
                LOGGER.info("Loaded {} command(s) from SPI providers", (Object)commandCount);
            } else {
                LOGGER.debug("No SPI command providers found");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to discover commands", (Throwable)e);
        }
    }

    public static class VersionProvider
    implements CommandLine.IVersionProvider {
        public String[] getVersion() throws Exception {
            String[] stringArray;
            block11: {
                InputStream input = InventoryToolMain.class.getClassLoader().getResourceAsStream("inventory.tool.build.properties");
                try {
                    if (input == null) {
                        throw new IllegalStateException("Required resource 'inventory.tool.build.properties' not found in classpath.");
                    }
                    Properties props = new Properties();
                    props.load(input);
                    String version = props.getProperty("inventory-tool.version");
                    if (version == null || version.trim().isEmpty()) {
                        throw new IllegalStateException("Version property 'inventory-tool.version' not found or empty in inventory.tool.build.properties.");
                    }
                    stringArray = new String[]{version};
                    if (input == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (e instanceof IllegalStateException) {
                            throw e;
                        }
                        throw new IllegalStateException("Failed to read version from inventory.tool.build.properties: " + e.getMessage(), e);
                    }
                }
                input.close();
            }
            return stringArray;
        }
    }
}

