/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli;

import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.QueryVerticle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="query", description={"Execute Gremlin query"}, mixinStandardHelpOptions=true)
public class QueryCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public QueryCommand() {
        this.properties.put("offlineMode", "true");
    }

    @CommandLine.Option(names={"-f", "--file"}, description={"JSON file that CLI should load instead of Graph dump"})
    public void setFile(String file) {
        this.properties.put("/query/file", file);
    }

    @CommandLine.Option(names={"-s", "--step"}, description={"Execution step for query (default is 'result' step)"})
    public void setStep(String step) {
        this.properties.put("/query/step", step);
    }

    @CommandLine.Option(names={"-l", "--login"}, description={"Login to access services requiring authentication"})
    public void setLogin(String login) {
        this.properties.put("login", login);
    }

    @CommandLine.Option(names={"--passwordSource"}, description={"Password source, default: \"file:password.txt\""})
    public void setPasswordSource(String passwordSource) {
        this.properties.put("passwordSource", passwordSource);
    }

    @CommandLine.Option(names={"--progressPath"}, description={"Path to progress folder (default is 'progress')"})
    public void setProgressPath(String progressPath) {
        this.properties.put("/query/progressPath", progressPath);
    }

    @Override
    public Integer call() throws Exception {
        LOGGER.info("Query command execution");
        this.runFlow(new QueryVerticle(), null);
        return 0;
    }
}

