/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.ci;

import org.qubership.itool.cli.AbstractCommand;
import picocli.CommandLine;

public abstract class AbstractCiCommand
extends AbstractCommand {
    public static final String DEFAULT_INPUT_DIRECTORY_DOCKER = "/var/input";
    public static final String DEFAULT_OUTPUT_DIRECTORY_DOCKER = "/var/output";
    public static final String DEFAULT_OUTPUT_DIRECTORY_DESKTOP = "progress";

    public AbstractCiCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
        this.properties.put("ciDefaultOutputDirectory", DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
    }

    @CommandLine.Option(names={"--inputDirectory"}, description={"Input directory path"})
    public void setInputDirectory(String inputDirectory) {
        this.properties.put("ciInputDirectory", inputDirectory);
    }

    @CommandLine.Option(names={"--outputDirectory"}, description={"Output directory path"})
    public void setOutputDirectory(String outputDirectory) {
        this.properties.put("ciOutputDirectory", outputDirectory);
    }

    @CommandLine.Option(names={"--defaultOutputDirectory"}, description={"Default output directory path"})
    public void setDefaultOutputDirectory(String defaultOutputDirectory) {
        this.properties.put("ciDefaultOutputDirectory", defaultOutputDirectory);
    }

    @CommandLine.Option(names={"--docker", "--dockerMode"}, description={"Docker mode: true/false"})
    public void setDockerMode(boolean dockerMode) {
        this.properties.put("ciDefaultOutputDirectory", dockerMode ? DEFAULT_OUTPUT_DIRECTORY_DOCKER : DEFAULT_OUTPUT_DIRECTORY_DESKTOP);
        this.properties.put("dockerMode", String.valueOf(dockerMode));
    }

    protected void logAndFillDirs() {
        boolean isDocker = Boolean.parseBoolean(this.properties.getOrDefault("dockerMode", "false"));
        this.getLogger().info("dockerMode: {}", (Object)isDocker);
        String defInputDirectory = this.getDefaultInputDir(isDocker);
        String defOutputDirectory = this.getDefaultOutputDir(isDocker);
        this.getLogger().info("explicit inputDirectory: {}", this.properties.get("ciInputDirectory"));
        this.getLogger().info("default inputDirectory: {}", (Object)defInputDirectory);
        this.getLogger().info("explicit outputDirectory: {}", this.properties.get("ciOutputDirectory"));
        this.getLogger().info("default outputDirectory: {}", (Object)defOutputDirectory);
        if (!this.properties.containsKey("ciInputDirectory")) {
            if (defInputDirectory != null) {
                this.properties.put("ciInputDirectory", DEFAULT_INPUT_DIRECTORY_DOCKER);
            } else {
                this.getLogger().error("Either --docker=true or --inputDirectory must be specified! EXITTING!");
                System.exit(1);
            }
        }
        if (!this.properties.containsKey("ciOutputDirectory") && defOutputDirectory != null) {
            this.properties.put("ciOutputDirectory", defOutputDirectory);
        }
    }

    protected String getDefaultInputDir(boolean isDocker) {
        return isDocker ? DEFAULT_INPUT_DIRECTORY_DOCKER : null;
    }

    protected String getDefaultOutputDir(boolean isDocker) {
        return (String)this.properties.get("ciDefaultOutputDirectory");
    }
}

