/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.ci;

import java.util.Properties;
import org.qubership.itool.cli.ci.AbstractCiCommand;
import org.qubership.itool.cli.ci.CiAssemblyVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ci-assembly", description={"CI flow: assembly"}, mixinStandardHelpOptions=true)
public class CiAssemblyCommand
extends AbstractCiCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiAssemblyCommand.class);

    public CiAssemblyCommand() {
        this.properties.put("ciOutputFile", "assembly.result.json");
    }

    @CommandLine.Option(names={"--outputFile"}, description={"Output file name for resulting graph"})
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @CommandLine.Option(names={"--appName"}, description={"Application name, e.g.: \"Inventory-Tool\""}, required=true)
    public void setAppName(String appName) {
        this.properties.put("ciAppName", appName);
    }

    @CommandLine.Option(names={"--appVersion"}, description={"Application version from builder, e.g.: \"main-SNAPSHOT\""})
    public void setAppVersion(String appVersion) {
        this.properties.put("ciAppVersion", appVersion);
    }

    @Override
    public Integer call() throws Exception {
        this.getLogger().info("Inventory tool assembly flow execution for CI (Picocli version)");
        this.logAndFillDirs();
        this.logConfiguration();
        this.runFlow(new CiAssemblyVerticle(), null);
        return 0;
    }

    private void logConfiguration() {
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.getLogger().info("appName: {}", this.properties.get("ciAppName"));
        this.getLogger().info("appVersion: {}", this.properties.get("ciAppVersion"));
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

