/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.ci;

import java.io.File;
import java.util.Properties;
import org.qubership.itool.cli.FlowMainVerticle;
import org.qubership.itool.cli.ci.AbstractCiCommand;
import org.qubership.itool.cli.ci.CiExecApplicationVerticle;
import org.qubership.itool.cli.ci.CiExecVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="ci-exec", description={"CI flow: parse a single component"}, mixinStandardHelpOptions=true)
public class CiExecCommand
extends AbstractCiCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(CiExecCommand.class);
    public static final String DEFAULT_OUTPUT_DIRECTORY_DESKTOP = "progress-ci";
    public static final String DEFAULT_INPUT_DIRECTORY_DOCKER = "/var/input";
    public static final String DEFAULT_OUTPUT_DIRECTORY_DOCKER = "/var/output";

    public CiExecCommand() {
        this.properties.put("ciMockDomain", "orphans");
    }

    @CommandLine.Option(names={"--componentName"}, description={"Component name in builder"}, required=true)
    public void setComponentName(String componentName) {
        this.properties.put("ciCompName", componentName);
    }

    @CommandLine.Option(names={"--componentVersion"}, description={"Component version in builder"})
    public void setComponentVersion(String componentVersion) {
        this.properties.put("ciCompVersion", componentVersion);
    }

    @CommandLine.Option(names={"--repository"}, description={"Repository of the target component"}, required=true)
    public void setRepository(String repository) {
        if ("null".equals(repository)) {
            this.getLogger().error("'null' repository name passed");
            System.exit(1);
        }
        this.properties.put("ciRepository", repository);
        String runName = repository.replaceFirst("^.*/(.*?)(\\.git)?$", "$1");
        this.properties.put("ciRunName", runName);
    }

    @CommandLine.Option(names={"--outputFile"}, description={"Output file name"})
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @CommandLine.Option(names={"--dumpResultsBy"}, description={"Strategy for automatic generation of output file name when it is not provided. Choices: hash, id, repo"})
    public void setDumpResultsBy(String dumpResults) {
        this.properties.put("ciDumpBy", dumpResults);
    }

    @Override
    public Integer call() throws Exception {
        this.getLogger().info("Inventory tool main flow execution for CI");
        this.logAndFillDirs();
        this.logConfiguration();
        this.runFlow(this.createMainVerticle(), null);
        return 0;
    }

    private void logConfiguration() {
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.getLogger().info("repository: {}", this.properties.get("ciRepository"));
        this.getLogger().info("releaseBranch: {}", this.properties.get("/release"));
        this.getLogger().info("componentName: {}", this.properties.get("ciCompName"));
        this.getLogger().info("componentVersion: {}", this.properties.get("ciCompVersion"));
    }

    protected FlowMainVerticle createMainVerticle() {
        String inputDir = (String)this.properties.get("ciInputDirectory");
        File appInvJson = new File(inputDir, "application_inventory.json");
        boolean appExec = false;
        if (appInvJson.isFile()) {
            this.getLogger().info("File {} exists!", (Object)appInvJson);
            appExec = true;
        } else {
            File appInvJson2 = new File(inputDir, "application-inventory.json");
            if (appInvJson2.isFile()) {
                this.getLogger().warn("File {} exists! Considering it as {}", (Object)appInvJson2, (Object)"application_inventory.json");
                appExec = true;
            }
        }
        if (appExec) {
            this.getLogger().info("==> switching to Application flow");
            return new CiExecApplicationVerticle();
        }
        this.getLogger().info("File {} does NOT exist", (Object)appInvJson);
        this.getLogger().info("==> Normal flow");
        return new CiExecVerticle();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

