/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.config;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.config.ConfigStoreOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.impl.future.SucceededFuture;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.io.Console;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigProvider.class);
    public static final List<String> HIDDEN_PROPERTIES = List.of("password");
    private Map<String, String> customProperties;
    private Vertx vertx;

    public ConfigProvider(Map<String, String> customProperties, Vertx vertx) {
        this.customProperties = customProperties;
        this.vertx = vertx;
    }

    public void handleConfig(Handler<AsyncResult<JsonObject>> asyncResultHandler) {
        ConfigRetriever retriever = ConfigProvider.retrieveConfig(this.customProperties, this.vertx);
        retriever.getConfig().onComplete(ar -> this.fillPassword((JsonObject)ar.result())).onComplete(asyncResultHandler);
    }

    public Future<JsonObject> fillPassword(JsonObject config) {
        String passwordStr;
        if (StringUtils.isNotEmpty((CharSequence)config.getString("password"))) {
            return new SucceededFuture((Object)config);
        }
        if (Boolean.parseBoolean(config.getString("offlineMode"))) {
            LOG.warn("Offline mode, got no password");
            return new SucceededFuture((Object)config);
        }
        String passwordUrl = config.getString("passwordSource");
        if (StringUtils.isNotEmpty((CharSequence)passwordUrl) && !"null".equals(passwordUrl) && (passwordStr = this.readPasswordFromUrl(passwordUrl)) != null) {
            config.put("password", (Object)passwordStr);
            return new SucceededFuture((Object)config);
        }
        WorkerExecutor executor = this.vertx.createSharedWorkerExecutor("console-password-asker", 1, 15L, TimeUnit.MINUTES);
        return executor.executeBlocking(() -> {
            String passwordStr = this.readPasswordFromConsole();
            config.put("password", (Object)passwordStr);
            return config;
        });
    }

    private String readPasswordFromUrl(String passwordUrl) {
        String string;
        block9: {
            URL url = new URL(passwordUrl);
            InputStream s = url.openStream();
            try {
                string = new LineNumberReader(new InputStreamReader(s)).readLine();
                if (s == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOG.warn("Exception when reading the password from a file: " + e.getMessage());
                    return null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            s.close();
        }
        return string;
    }

    private String readPasswordFromConsole() {
        try {
            int l;
            Console console = System.console();
            if (console != null) {
                return new String(console.readPassword("Password: ", new Object[0]));
            }
            System.out.print("Password: ");
            InputStream in = System.in;
            int max = 50;
            byte[] b = new byte[max];
            for (l = in.read(b); l > 0 && (b[l - 1] == 13 || b[l - 1] == 10); --l) {
            }
            if (l > 0) {
                return new String(b, 0, l);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static ConfigRetriever retrieveConfig(Map<String, String> customProperties, Vertx vertx) {
        JsonObject config = new JsonObject();
        Pattern booleanPattern = Pattern.compile("true|false", 2);
        for (Map.Entry<String, String> e : customProperties.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (key.startsWith("/")) {
                JsonPointer pointer = JsonPointer.from((String)key);
                if (booleanPattern.matcher(value).matches()) {
                    pointer.writeJson((Object)config, (Object)Boolean.valueOf(value), true);
                    continue;
                }
                pointer.writeJson((Object)config, (Object)StringUtils.trimToEmpty((String)value), true);
                continue;
            }
            config.put(key, (Object)StringUtils.trimToEmpty((String)value));
        }
        ConfigStoreOptions defaultProfile = new ConfigStoreOptions().setType("file").setFormat("properties").setConfig(new JsonObject().put("path", (Object)Path.of(ConfigUtils.getConfigValue("/configPath", config), "default", "config", "profiles", "default.properties").toString()).put("hierarchical", (Object)true));
        Object profile = ConfigUtils.getConfigValue("/profile", config);
        String profileType = "properties";
        if (profile == null) {
            profile = "";
        }
        if (((String)profile).contains(".")) {
            profileType = ((String)profile).split("\\.")[1];
        } else {
            profile = (String)profile + "." + profileType;
        }
        ConfigStoreOptions customProfile = new ConfigStoreOptions().setType("file").setFormat(profileType).setOptional(true).setConfig(new JsonObject().put("path", (Object)Path.of(ConfigUtils.getConfigValue("/configPath", config), new String[]{"default", "config", "profiles", profile}).toString()).put("hierarchical", (Object)true));
        ConfigStoreOptions argsJson = new ConfigStoreOptions().setType("json").setConfig(config);
        ConfigRetriever retriever = ConfigRetriever.create((Vertx)vertx, (ConfigRetrieverOptions)new ConfigRetrieverOptions().addStore(defaultProfile).addStore(customProfile).addStore(argsJson));
        return retriever;
    }
}

