/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.extract;

import java.util.Properties;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.extract.ExtractMainVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="extract", description={"Extract Language and Framework data from Graph"}, mixinStandardHelpOptions=true)
public class ExtractCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public ExtractCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
    }

    @CommandLine.Option(names={"--inputFile"}, description={"Input file name"}, required=true)
    public void setInputFile(String inputFile) {
        this.properties.put("ciInputFile", inputFile);
    }

    @CommandLine.Option(names={"--outputFile"}, description={"Output file name"}, required=true)
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @Override
    public Integer call() throws Exception {
        this.getLogger().info("Graph data extraction flow execution");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("inputFile: {}", this.properties.get("ciInputFile"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.runFlow(new ExtractMainVerticle(), null);
        return 0;
    }
}

