/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.obfuscate;

import java.util.Properties;
import org.qubership.itool.cli.AbstractCommand;
import org.qubership.itool.cli.obfuscate.ObfuscationMainVerticle;
import org.qubership.itool.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="obfuscate", description={"Obfuscate Graph"}, mixinStandardHelpOptions=true)
public class ObfuscateCommand
extends AbstractCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObfuscateCommand.class);

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public ObfuscateCommand() {
        this.properties.put("/profile", "ci");
        this.properties.put("offlineMode", "true");
        this.properties.put("saveProgress", "false");
    }

    @CommandLine.Option(names={"--inputDirectory"}, description={"Input directory"})
    public void setInputDirectory(String inputDirectory) {
        this.properties.put("ciInputDirectory", inputDirectory);
    }

    @CommandLine.Option(names={"--inputFile"}, description={"Input file name"}, required=true)
    public void setInputFile(String inputFile) {
        this.properties.put("ciInputFile", inputFile);
    }

    @CommandLine.Option(names={"--outputDirectory"}, description={"Output directory"})
    public void setOutputDirectory(String outputDirectory) {
        this.properties.put("ciOutputDirectory", outputDirectory);
    }

    @CommandLine.Option(names={"--outputFile"}, description={"Output file name"}, required=true)
    public void setOutputFile(String outputFile) {
        this.properties.put("ciOutputFile", outputFile);
    }

    @CommandLine.Option(names={"-r", "--obfuscationRules"}, description={"Path to the obfuscated graph dump"})
    public void setObfuscationRules(String obfuscationRules) {
        this.properties.put("obfuscationRules", obfuscationRules);
    }

    @Override
    public Integer call() throws Exception {
        this.getLogger().info("Obfuscation main flow execution");
        this.getLogger().info("----- Configuration -----");
        Properties buildProperties = ConfigUtils.getInventoryToolBuildProperties();
        this.getLogger().info("cli version: {}", buildProperties.get("inventory-tool-cli.version"));
        this.getLogger().info("profile: {}", this.properties.get("/profile"));
        this.getLogger().info("inputDirectory: {}", this.properties.get("ciInputDirectory"));
        this.getLogger().info("inputFile: {}", this.properties.get("ciInputFile"));
        this.getLogger().info("explicit outputDirectory: {}", this.properties.get("ciOutputDirectory"));
        this.getLogger().info("outputFile: {}", this.properties.get("ciOutputFile"));
        this.runFlow(new ObfuscationMainVerticle(), null);
        return 0;
    }
}

