/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.cli.query.cmd;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.itool.cli.query.CliContext;
import org.qubership.itool.cli.query.QueryItem;
import org.qubership.itool.cli.query.cmd.AbstractCliCommand;
import org.qubership.itool.utils.FSUtils;

public class SavePredefinedQueryCommand
extends AbstractCliCommand {
    private static final Pattern COMMAND_PATTERN = Pattern.compile("save query\\(\"(\\w+)\"(?:,\\s\"(.*)\")\\);");

    public SavePredefinedQueryCommand(CliContext context) {
        super(context);
    }

    @Override
    public String name() {
        return "save query(name, description);";
    }

    @Override
    public String description() {
        return "Save last query (predefined list). Example: save query(\"superQuery\", \"some description\")";
    }

    @Override
    public boolean acceptCommand(String command) {
        return command.startsWith("save query(");
    }

    @Override
    public Object doCommand(String command) {
        Matcher matcher = COMMAND_PATTERN.matcher(command);
        if (!matcher.matches()) {
            System.out.println("Wrong command. Example: save query(\"name\", \"description\");");
            return null;
        }
        String lastExecutedQuery = (String)this.context().getValue("lastExecutedQuery");
        List queryItemList = (List)this.context().getValue("queryItems");
        String method = matcher.group(1) + "()";
        String description = matcher.group(2);
        QueryItem item = new QueryItem(method, description, lastExecutedQuery);
        StringBuilder text = new StringBuilder();
        text.append("\n");
        text.append(item.getMethod()).append("\n");
        text.append(item.getDescription()).append("\n");
        text.append(item.getQuery()).append("\n\n");
        try {
            FSUtils.appendFile("inventory-tool/default/config/cli/query_custom.txt", text.toString());
        }
        catch (IOException e) {
            System.out.println("Can't add custom query. Reason: " + e.getMessage());
        }
        queryItemList.add(item);
        System.out.println("Query saved with name: " + item.getMethod());
        return null;
    }
}

