/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.di;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import org.qubership.itool.context.FlowContext;
import org.qubership.itool.context.FlowContextImpl;
import org.qubership.itool.modules.confluence.ConfluenceClient;
import org.qubership.itool.modules.confluence.ConfluenceClientBuilder;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitAdapterBuilder;
import org.qubership.itool.modules.git.GitFileRetriever;
import org.qubership.itool.modules.git.GitFileRetrieverBuilder;
import org.qubership.itool.modules.graph.GraphClassifierBuilder;
import org.qubership.itool.modules.graph.GraphClassifierBuilderImpl;
import org.qubership.itool.modules.parsing.InventoryJsonParser;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.modules.template.ConfluencePage;
import org.qubership.itool.utils.YamlParser;

public class CliModule
extends AbstractModule {
    protected void configure() {
        this.bind(FlowContext.class).to(FlowContextImpl.class).in(Singleton.class);
        this.bind(YamlParser.class).in(Singleton.class);
        this.bind(InventoryJsonParser.class).in(Singleton.class);
        this.bind(ConfluencePage.class);
        this.bind(GraphClassifierBuilder.class).to(GraphClassifierBuilderImpl.class);
    }

    @Provides
    @Singleton
    public WebClient provideWebClient(Vertx vertx) {
        return WebClient.create((Vertx)vertx);
    }

    @Provides
    public GitAdapter provideGitAdapter(Vertx vertx, GraphReport report, @Named(value="application.config") JsonObject config) {
        return GitAdapterBuilder.create(vertx, report, config);
    }

    @Provides
    public ConfluenceClient provideConfluenceClient(Vertx vertx, WebClient webClient, @Named(value="application.config") JsonObject config) {
        return ConfluenceClientBuilder.create(vertx, webClient, config);
    }

    @Provides
    public GitFileRetriever provideGitFileRetriever(GitAdapter gitAdapter, @Named(value="application.config") JsonObject config, Vertx vertx, GraphReport report) {
        return GitFileRetrieverBuilder.create(gitAdapter, config, vertx, report);
    }
}

