/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.di;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.function.Function;
import org.qubership.itool.modules.processor.GraphMerger;
import org.qubership.itool.modules.processor.MergerApi;
import org.qubership.itool.modules.processor.matchers.CompoundVertexMatcher;
import org.qubership.itool.modules.processor.matchers.DefaultMockFieldExtractor;
import org.qubership.itool.modules.processor.matchers.FileMatcher;
import org.qubership.itool.modules.processor.matchers.MatcherById;
import org.qubership.itool.modules.processor.matchers.MockFieldExtractor;
import org.qubership.itool.modules.processor.matchers.SourceMocksMatcher;
import org.qubership.itool.modules.processor.matchers.TargetMocksMatcher;
import org.qubership.itool.modules.processor.tasks.CreateAppVertexTask;
import org.qubership.itool.modules.processor.tasks.CreateTransitiveHttpDependenciesTask;
import org.qubership.itool.modules.processor.tasks.CreateTransitiveQueueDependenciesTask;
import org.qubership.itool.modules.processor.tasks.GraphProcessorTask;
import org.qubership.itool.modules.processor.tasks.PatchAppVertexTask;
import org.qubership.itool.modules.processor.tasks.PatchIsMicroserviceFieldTask;
import org.qubership.itool.modules.processor.tasks.PatchLanguagesNormalizationTask;
import org.qubership.itool.modules.processor.tasks.PatchMockedComponentsNormalizationTask;
import org.qubership.itool.modules.processor.tasks.PatchVertexDnsNamesNormalizationTask;
import org.qubership.itool.modules.processor.tasks.RecreateDomainsStructureTask;
import org.qubership.itool.modules.processor.tasks.RecreateHttpDependenciesTask;

public class MergerModule
extends AbstractModule {
    protected void configure() {
        this.bind(MergerApi.class).to(GraphMerger.class);
        this.bind(MockFieldExtractor.class).to(DefaultMockFieldExtractor.class).in(Scopes.SINGLETON);
        this.bind(CreateTransitiveQueueDependenciesTask.class);
        this.bind(CreateTransitiveHttpDependenciesTask.class);
        this.bind(RecreateHttpDependenciesTask.class);
        this.bind(RecreateDomainsStructureTask.class);
        this.bind(TargetMocksMatcher.class);
        this.bind(SourceMocksMatcher.class);
    }

    @Provides
    @Named(value="normalization.tasks")
    public List<GraphProcessorTask> provideNormalizationTasksList() {
        return List.of(new PatchIsMicroserviceFieldTask(), new PatchMockedComponentsNormalizationTask(), new PatchVertexDnsNamesNormalizationTask(), new PatchLanguagesNormalizationTask());
    }

    @Provides
    @Named(value="finalization.tasks")
    public List<GraphProcessorTask> provideFinalizationTasks(CreateTransitiveQueueDependenciesTask createTransitiveQueueDependenciesTask, CreateTransitiveHttpDependenciesTask createTransitiveHttpDependenciesTask, RecreateDomainsStructureTask recreateDomainsStructureTask, RecreateHttpDependenciesTask recreateHttpDependenciesTask) {
        return List.of(recreateHttpDependenciesTask, createTransitiveQueueDependenciesTask, createTransitiveHttpDependenciesTask, recreateDomainsStructureTask);
    }

    @Provides
    public CompoundVertexMatcher provideCompoundVertexMatcher(TargetMocksMatcher targetMocksMatcher, SourceMocksMatcher sourceMocksMatcher) {
        return new CompoundVertexMatcher(new MatcherById(), targetMocksMatcher, sourceMocksMatcher, new FileMatcher());
    }

    @Provides
    @Singleton
    public Function<JsonObject, CreateAppVertexTask> provideCreateAppVertexTaskFactory() {
        return CreateAppVertexTask::new;
    }

    @Provides
    @Singleton
    public Function<JsonObject, PatchAppVertexTask> providePatchAppVertexTaskFactory() {
        return PatchAppVertexTask::new;
    }
}

