/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.artifactory;

import com.google.common.net.UrlEscapers;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.artifactory.AppDBConfig;
import org.qubership.itool.modules.artifactory.AppsDBIntegration;
import org.qubership.itool.modules.artifactory.ArtifactKind;
import org.qubership.itool.modules.artifactory.ArtifactoryConfig;
import org.qubership.itool.modules.artifactory.ResourceLocator;
import org.qubership.itool.modules.artifactory.RetrievalException;
import org.qubership.itool.modules.artifactory.RetrievalHttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDBIntegrationImpl
implements AppsDBIntegration {
    protected static final Logger LOG = LoggerFactory.getLogger(AppDBIntegrationImpl.class);
    protected final WebClient webClient;
    protected final AppDBConfig config;
    protected final ConcurrentMap<String, ArtifactoryConfig> registryCache = new ConcurrentHashMap<String, ArtifactoryConfig>();

    public AppDBIntegrationImpl(WebClient webClient, AppDBConfig config) {
        this.webClient = webClient;
        this.config = config;
    }

    @Override
    public Future<List<String>> getApplicationNames() {
        String url = this.config.getUrl() + "applications/view";
        this.getLogger().info("Downloading: {} using Basic auth: {}:******", (Object)url, (Object)this.config.getUser());
        return this.webClient.requestAbs(HttpMethod.GET, url).basicAuthentication(this.config.getUser(), this.config.getPassword()).send().map(response -> this.responseToJsonArray(url, (HttpResponse<Buffer>)response).stream().map(obj -> this.getString(obj, "name")).filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
    }

    @Override
    public Future<ResourceLocator> getAppResourceLocator(String appName) {
        String url = this.config.getUrl() + "applications/" + UrlEscapers.urlPathSegmentEscaper().escape(appName);
        this.getLogger().info("Downloading: {} using Basic auth: {}:******", (Object)url, (Object)this.config.getUser());
        return this.webClient.requestAbs(HttpMethod.GET, url).basicAuthentication(this.config.getUser(), this.config.getPassword()).send().map(response -> this.responseToJsonObject(url, (HttpResponse<Buffer>)response)).flatMap(appConfig -> this.getArtifactory((JsonObject)appConfig).map(artifactoryConfig -> {
            String groupId = appConfig.getString("appGid");
            String artifactId = appConfig.getString("appAid");
            this.getLogger().debug("Mapped: {} -> {}:{} in {}", new Object[]{appName, groupId, artifactId, artifactoryConfig});
            return new ResourceLocator((ArtifactoryConfig)artifactoryConfig, ArtifactKind.APPLICATION, groupId, artifactId);
        })).recover(t -> {
            if (t instanceof RetrievalException) {
                return Future.failedFuture((Throwable)t);
            }
            return Future.failedFuture((Throwable)new RetrievalException("Failed to get application data from applications database", (Throwable)t));
        });
    }

    @Override
    public void clearCaches() {
        this.registryCache.clear();
    }

    @Override
    public Future<ArtifactoryConfig> getArtifactory(JsonObject appConfig) {
        String registryName = appConfig.getString("registryName");
        String appName = appConfig.getString("name");
        this.getLogger().debug("Application '{}' resides in registry '{}'", (Object)appName, (Object)registryName);
        ArtifactoryConfig artConf = (ArtifactoryConfig)this.registryCache.get(registryName);
        if (artConf != null) {
            return Future.succeededFuture((Object)artConf);
        }
        String url = this.config.getUrl() + "registry/" + UrlEscapers.urlPathSegmentEscaper().escape(registryName);
        this.getLogger().info("Downloading: {} using Basic auth: {}:******", (Object)url, (Object)this.config.getUser());
        return this.webClient.requestAbs(HttpMethod.GET, url).basicAuthentication(this.config.getUser(), this.config.getPassword()).send().map(response -> this.responseToJsonObject(url, (HttpResponse<Buffer>)response)).map(regConfig -> {
            String entry;
            String[] mavenEntries;
            String server = (String)JsonPointer.from((String)"/maven/REPOSITORY_DOMAIN_NAME").queryJson(regConfig);
            String storage = null;
            String mavenEntryList = this.config.getMavenEntry();
            String[] stringArray = mavenEntries = mavenEntryList.split(",");
            int n = stringArray.length;
            for (int i = 0; i < n && !StringUtils.isNotEmpty((CharSequence)(storage = (String)JsonPointer.from((String)("/maven/" + (entry = stringArray[i]).trim())).queryJson(regConfig))); ++i) {
            }
            if (StringUtils.isEmpty(storage)) {
                throw new RetrievalException("Registry " + registryName + " has no configured storages " + this.config.getMavenEntry() + " for application" + appName);
            }
            ArtifactoryConfig ac = new ArtifactoryConfig(server, storage);
            this.getLogger().debug("Registry '{}', entries '{}' -> {}", new Object[]{registryName, this.config.getMavenEntry(), ac});
            this.registryCache.put(registryName, ac);
            return ac;
        });
    }

    @Override
    public JsonObject responseToJsonObject(String url, HttpResponse<Buffer> response) {
        this.checkResponse(url, response);
        return response.bodyAsJsonObject();
    }

    @Override
    public JsonArray responseToJsonArray(String url, HttpResponse<Buffer> response) {
        this.checkResponse(url, response);
        return response.bodyAsJsonArray();
    }

    @Override
    public void checkResponse(String url, HttpResponse<Buffer> response) {
        int statusCode = response.statusCode();
        if (statusCode != 200) {
            throw new RetrievalHttpException(url, response);
        }
    }

    @Override
    public String getString(Object container, String key) {
        if (container instanceof JsonObject) {
            return ((JsonObject)container).getString(key);
        }
        if (container instanceof Map) {
            return (String)((Map)container).get(key);
        }
        return null;
    }

    public Logger getLogger() {
        return LOG;
    }
}

