/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.artifactory;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.artifactory.AppDBIntegrationImpl;
import org.qubership.itool.modules.artifactory.AppsDBIntegration;
import org.qubership.itool.modules.artifactory.GraphSnapshot;
import org.qubership.itool.modules.artifactory.JsonSnapshot;
import org.qubership.itool.modules.artifactory.ResourceLocator;
import org.qubership.itool.modules.artifactory.RetrievalException;
import org.qubership.itool.modules.artifactory.RetrievalHttpException;
import org.qubership.itool.modules.artifactory.SnapshotFilter;
import org.qubership.itool.utils.FutureUtils;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ArtifactRetriever {
    public static final String GRAPH_CLASSIFIER = "graph";
    public static final String GRAPH_GZ_CLASSIFIER = "graph";
    public static final String JSON_EXTENSION = "json";
    public static final String JSON_GZ_EXTENSION = "json.gz";
    public static final List<SnapshotFilter> GRAPH_FILTERS = List.of(new SnapshotFilter("graph", "json"), new SnapshotFilter("graph", "json.gz"));
    protected static final Logger LOG = LoggerFactory.getLogger(ArtifactRetriever.class);
    protected static final XPath xpath = XPathFactory.newInstance().newXPath();
    protected static final int HTTP_NOT_FOUND = 404;
    protected static final int HTTP_CONFLICT = 409;
    protected final WebClient webClient;
    private static volatile Map<String, XPathExpression> snapshotInfoFields;

    public ArtifactRetriever(WebClient webClient) {
        this.webClient = webClient;
    }

    public Future<List<String>> retrieveArtifactVersions(ResourceLocator locator) {
        String urlString = locator.getBaseUrl() + "maven-metadata.xml";
        return this.downloadUrlAsBuffer(urlString).transform(ar -> {
            if (ar.failed()) {
                if (this.isNotFound((AsyncResult<?>)ar)) {
                    return Future.succeededFuture(Collections.emptyList());
                }
                return Future.failedFuture((Throwable)ar.cause());
            }
            try {
                Buffer buf = (Buffer)ar.result();
                Document doc = XmlParser.parseXmlData(buf, urlString);
                NodeList snapshotData = (NodeList)xpath.compile("/metadata/versioning/versions/version/text()").evaluate(doc, XPathConstants.NODESET);
                int length = snapshotData.getLength();
                ArrayList<String> collector = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    Text item = (Text)snapshotData.item(i);
                    collector.add(item.getTextContent());
                }
                return Future.succeededFuture(collector);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)new RetrievalException("Failure when parsing " + urlString, e));
            }
        });
    }

    public Future<List<String>> retrieveAppVersions(AppsDBIntegration appsDBintegration, String appName) {
        return appsDBintegration.getAppResourceLocator(appName).flatMap(locator -> this.retrieveArtifactVersions((ResourceLocator)locator));
    }

    public Future<GraphSnapshot> retrieveLatestGraphDump(ResourceLocator locator, String versionId) {
        return this.retrieveGraphDumpSnapshots(locator, versionId).transform(descriptorsAr -> {
            if (descriptorsAr.failed()) {
                if (this.isNotFound((AsyncResult<?>)descriptorsAr)) {
                    this.getLogger().warn("{} not found, falling back to manual search for artifacts", (Object)((RetrievalHttpException)descriptorsAr.cause()).urlString);
                    List downloads = this.downloadGraphArtifactsWithoutMavenMetadata(locator, versionId);
                    return FutureUtils.anyFuture(downloads);
                }
                return Future.failedFuture((Throwable)descriptorsAr.cause());
            }
            List descriptors = (List)descriptorsAr.result();
            this.getLogger().info("Graph snapshots for [{}:{}:{}] found: {}", new Object[]{locator.getGroupId(), locator.getArtifactId(), versionId, descriptors});
            if (descriptors.isEmpty()) {
                return Future.failedFuture((Throwable)new RetrievalException("No graph snapshots found for " + locator.getGroupId() + ":" + locator.getArtifactId() + ":" + versionId));
            }
            GraphSnapshot descriptor = (GraphSnapshot)descriptors.get(0);
            return this.retrieveGraphSnapshot(locator, versionId, descriptor);
        });
    }

    public Future<GraphSnapshot> retrieveLatestAppGraphDump(AppsDBIntegration appsDBIntegration, String appName, String versionId) {
        return appsDBIntegration.getAppResourceLocator(appName).flatMap(locator -> this.retrieveLatestGraphDump((ResourceLocator)locator, versionId));
    }

    public Future<JsonSnapshot> retrieveLatestJsonSnapshot(ResourceLocator locator, String versionId, List<SnapshotFilter> filters) {
        return this.retrieveJsonSnapshots(locator, versionId, filters).transform(descriptorsAr -> {
            if (descriptorsAr.failed()) {
                if (this.isNotFound((AsyncResult<?>)descriptorsAr)) {
                    this.getLogger().warn("{} not found, falling back to manual search for artifacts", (Object)((RetrievalHttpException)descriptorsAr.cause()).urlString);
                    List downloads = this.downloadJsonArtifactsWithoutMavenMetadata(locator, versionId, filters);
                    return FutureUtils.anyFuture(downloads);
                }
                return Future.failedFuture((Throwable)descriptorsAr.cause());
            }
            List descriptors = (List)descriptorsAr.result();
            this.getLogger().info("JSON snapshots for [{}:{}:{}] found: {}", new Object[]{locator.getGroupId(), locator.getArtifactId(), versionId, descriptors});
            if (descriptors.isEmpty()) {
                return Future.failedFuture((Throwable)new RetrievalException("No JSON snapshots found for [" + locator.getGroupId() + ":" + locator.getArtifactId() + ":" + versionId + "] and filters: " + String.valueOf(filters)));
            }
            JsonSnapshot descriptor = (JsonSnapshot)descriptors.get(0);
            return this.retrieveJsonSnapshot(locator, versionId, descriptor);
        });
    }

    protected boolean isNotFound(AsyncResult<?> webResponse) {
        Throwable cause = webResponse.cause();
        if (cause instanceof RetrievalHttpException) {
            int statusCode = ((RetrievalHttpException)cause).getStatusCode();
            return statusCode == 404 || statusCode == 409;
        }
        return false;
    }

    public Future<List<GraphSnapshot>> retrieveGraphDumpSnapshots(ResourceLocator locator, String versionId) {
        String urlString = locator.getBaseUrl(versionId) + "maven-metadata.xml";
        return this.downloadUrlAsBuffer(urlString).flatMap(buf -> {
            try {
                NodeList snapshotData = this.parseSnapshotVersions(urlString, (Buffer)buf);
                ArrayList<GraphSnapshot> collector = new ArrayList<GraphSnapshot>();
                for (int i = 0; i < snapshotData.getLength(); ++i) {
                    Element item = (Element)snapshotData.item(i);
                    GraphSnapshot desc = this.toGraphSnapshot(item);
                    if (!GRAPH_FILTERS.stream().anyMatch(filter -> filter.matches(desc))) continue;
                    collector.add(desc);
                }
                return Future.succeededFuture(collector);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)new RetrievalException("Failure when parsing " + urlString, e));
            }
        });
    }

    public Future<List<JsonSnapshot>> retrieveJsonSnapshots(ResourceLocator locator, String versionId, List<SnapshotFilter> filters) {
        String urlString = locator.getBaseUrl(versionId) + "maven-metadata.xml";
        return this.downloadUrlAsBuffer(urlString).flatMap(buf -> {
            try {
                NodeList snapshotData = this.parseSnapshotVersions(urlString, (Buffer)buf);
                ArrayList<JsonSnapshot> collector = new ArrayList<JsonSnapshot>();
                for (int i = 0; i < snapshotData.getLength(); ++i) {
                    Element item = (Element)snapshotData.item(i);
                    JsonSnapshot desc = this.toJsonSnapshot(item);
                    if (!filters.stream().anyMatch(filter -> filter.matches(desc))) continue;
                    collector.add(desc);
                }
                return Future.succeededFuture(collector);
            }
            catch (Exception e) {
                return Future.failedFuture((Throwable)new RetrievalException("Failure when parsing " + urlString, e));
            }
        });
    }

    protected NodeList parseSnapshotVersions(String urlString, Buffer buf) throws Exception {
        Document doc = XmlParser.parseXmlData(buf, urlString);
        NodeList snapshotData = (NodeList)xpath.compile("/metadata/versioning/snapshotVersions/snapshotVersion").evaluate(doc, XPathConstants.NODESET);
        return snapshotData;
    }

    public Future<List<GraphSnapshot>> retrieveAppGraphDumpSnapshots(AppsDBIntegration appsDBIntegration, String appName, String versionId) {
        return appsDBIntegration.getAppResourceLocator(appName).flatMap(locator -> this.retrieveGraphDumpSnapshots((ResourceLocator)locator, versionId));
    }

    protected List<Future<GraphSnapshot>> downloadGraphArtifactsWithoutMavenMetadata(ResourceLocator locator, String versionId) {
        return GRAPH_FILTERS.stream().map(sf -> {
            String urlString = locator.getReleaseArtifactUrl(versionId, (SnapshotFilter)sf);
            return this.downloadJson(urlString, sf.getExtension()).recover(f -> {
                RetrievalHttpException ex;
                if (versionId.endsWith("-RELEASE")) {
                    return Future.failedFuture((Throwable)f);
                }
                if (f instanceof RetrievalHttpException && (ex = (RetrievalHttpException)f).getStatusCode() != 404) {
                    return Future.failedFuture((Throwable)f);
                }
                return this.downloadJson(locator.getSnapshotArtifactUrl(versionId, (SnapshotFilter)sf), sf.getExtension());
            }).map(dump -> this.toGraphSnapshot((SnapshotFilter)sf, urlString, (JsonObject)dump));
        }).collect(Collectors.toList());
    }

    protected List<Future<JsonSnapshot>> downloadJsonArtifactsWithoutMavenMetadata(ResourceLocator locator, String versionId, List<SnapshotFilter> filters) {
        return filters.stream().map(sf -> {
            String urlString = locator.getReleaseArtifactUrl(versionId, (SnapshotFilter)sf);
            return this.downloadJson(urlString, sf.getExtension()).map(json -> this.toJsonSnapshot((SnapshotFilter)sf, urlString, (JsonObject)json));
        }).collect(Collectors.toList());
    }

    protected GraphSnapshot toGraphSnapshot(SnapshotFilter sf, String urlString, JsonObject dump) {
        GraphSnapshot snapshot = new GraphSnapshot();
        snapshot.setOriginUrl(urlString);
        snapshot.setClassifier(sf.getClassifier());
        snapshot.setExtension(sf.getExtension());
        snapshot.setGraphDump(dump);
        return snapshot;
    }

    protected JsonSnapshot toJsonSnapshot(SnapshotFilter sf, String urlString, JsonObject data) {
        JsonSnapshot snapshot = new JsonSnapshot();
        snapshot.setOriginUrl(urlString);
        snapshot.setClassifier(sf.getClassifier());
        snapshot.setExtension(sf.getExtension());
        snapshot.setData(data);
        return snapshot;
    }

    protected GraphSnapshot toGraphSnapshot(Element item) throws Exception {
        GraphSnapshot snapshot = new GraphSnapshot();
        Map<String, XPathExpression> fields = ArtifactRetriever.getSnapshotInfoFields();
        snapshot.setClassifier((String)fields.get("classifier").evaluate(item, XPathConstants.STRING));
        snapshot.setExtension((String)fields.get("extension").evaluate(item, XPathConstants.STRING));
        snapshot.setSnapshotId((String)fields.get("snapshotId").evaluate(item, XPathConstants.STRING));
        snapshot.setUpdated((String)fields.get("updated").evaluate(item, XPathConstants.STRING));
        return snapshot;
    }

    protected JsonSnapshot toJsonSnapshot(Element item) throws Exception {
        JsonSnapshot snapshot = new JsonSnapshot();
        Map<String, XPathExpression> fields = ArtifactRetriever.getSnapshotInfoFields();
        snapshot.setClassifier((String)fields.get("classifier").evaluate(item, XPathConstants.STRING));
        snapshot.setExtension((String)fields.get("extension").evaluate(item, XPathConstants.STRING));
        snapshot.setSnapshotId((String)fields.get("snapshotId").evaluate(item, XPathConstants.STRING));
        snapshot.setUpdated((String)fields.get("updated").evaluate(item, XPathConstants.STRING));
        return snapshot;
    }

    protected Future<GraphSnapshot> retrieveGraphSnapshot(ResourceLocator locator, String versionId, GraphSnapshot snapshot) {
        String urlString = locator.getArtifactUrl(versionId, snapshot);
        return this.downloadJson(urlString, snapshot.getExtension()).map(dump -> {
            snapshot.setOriginUrl(urlString);
            snapshot.setGraphDump((JsonObject)dump);
            return snapshot;
        });
    }

    protected Future<JsonSnapshot> retrieveJsonSnapshot(ResourceLocator locator, String versionId, JsonSnapshot snapshot) {
        String urlString = locator.getArtifactUrl(versionId, snapshot);
        return this.downloadJson(urlString, snapshot.getExtension()).map(json -> {
            snapshot.setOriginUrl(urlString);
            snapshot.setData((JsonObject)json);
            return snapshot;
        });
    }

    protected static Map<String, XPathExpression> getSnapshotInfoFields() throws Exception {
        if (snapshotInfoFields == null) {
            snapshotInfoFields = Map.of("classifier", xpath.compile("classifier/text()"), "extension", xpath.compile("extension/text()"), "snapshotId", xpath.compile("value/text()"), "updated", xpath.compile("updated/text()"));
        }
        return snapshotInfoFields;
    }

    protected Future<JsonObject> downloadJson(String urlString, String extension) {
        return this.downloadUrlAsBuffer(urlString).map(buffer -> {
            try {
                switch (StringUtils.defaultString((String)extension)) {
                    case "json": {
                        return JsonUtils.bufferToJsonObject(buffer);
                    }
                    case "json.gz": {
                        return JsonUtils.gzipBufferToJsonObject(buffer);
                    }
                }
                throw new RetrievalException("Internal error: unrecognized extension: " + extension);
            }
            catch (IOException e) {
                throw new RetrievalException(e);
            }
        });
    }

    protected Future<Buffer> downloadUrlAsBuffer(String urlString) {
        this.getLogger().info("Downloading: {}", (Object)urlString);
        return this.webClient.requestAbs(HttpMethod.GET, urlString).send().map(response -> {
            int statusCode = response.statusCode();
            if (statusCode == 200) {
                this.getLogger().info("Found: {}", (Object)urlString);
                return response.bodyAsBuffer();
            }
            if (statusCode == 404 || statusCode == 409) {
                this.getLogger().info("Not found: {}", (Object)urlString);
            }
            throw new RetrievalHttpException(urlString, (HttpResponse<Buffer>)response);
        });
    }

    public Future<GraphSnapshot> retrieveAppGraphDump(AppDBIntegrationImpl appDBIntegration, String appName, String versionId) {
        return appDBIntegration.getAppResourceLocator(appName).flatMap(locator -> this.retrieveGraphDump((ResourceLocator)locator, versionId));
    }

    public Future<GraphSnapshot> retrieveGraphDump(ResourceLocator locator, String versionId) {
        if (versionId == null) {
            return Future.failedFuture((String)"VersionId is null");
        }
        if (versionId.endsWith("-SNAPSHOT")) {
            this.getLogger().debug("Scheduling the retrieval of the latest graph snapshot for artifactId={} with version={}", (Object)locator.getArtifactId(), (Object)versionId);
            return this.retrieveLatestGraphDump(locator, versionId);
        }
        this.getLogger().debug("Scheduling the retrieval of the graph snapshot for artifactId={} with version={}", (Object)locator.getArtifactId(), (Object)versionId);
        List downloads = this.downloadGraphArtifactsWithoutMavenMetadata(locator, versionId);
        return FutureUtils.anyFuture(downloads);
    }

    protected Logger getLogger() {
        return LOG;
    }
}

