/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.artifactory;

import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.artifactory.ArtifactKind;
import org.qubership.itool.modules.artifactory.ArtifactoryConfig;
import org.qubership.itool.modules.artifactory.Snapshot;
import org.qubership.itool.modules.artifactory.SnapshotFilter;

public class ResourceLocator {
    public static final String DEFAULT_APP_VERSION = "main-SNAPSHOT";
    public static final String SNAPSHOT_VERSION_EXTRACTION_PATTERN = "^([-\\S]+)\\-(?:\\d{8}\\.\\d{6}-\\d+)$";
    private final ArtifactoryConfig artifactory;
    private final ArtifactKind kind;
    private final String groupId;
    private final String groupIdNormalized;
    private final String artifactId;

    public ResourceLocator(ArtifactoryConfig artifactory, ArtifactKind kind, String groupId, String artifactId) {
        this.artifactory = artifactory;
        this.kind = kind;
        this.groupId = groupId;
        this.groupIdNormalized = groupId != null ? groupId.replace('.', '/') + "/" : "";
        this.artifactId = artifactId;
    }

    public static ResourceLocator forApplication(ArtifactoryConfig artifactory, String groupId, String applicationId) {
        return new ResourceLocator(artifactory, ArtifactKind.APPLICATION, groupId, applicationId);
    }

    public static ResourceLocator forComponent(ArtifactoryConfig artifactory, String groupId, String componentId) {
        return new ResourceLocator(artifactory, ArtifactKind.COMPONENT, groupId, componentId);
    }

    public ArtifactKind getKind() {
        return this.kind;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getBaseUrl() {
        return this.artifactory.server + "/" + this.artifactory.storage + "/" + this.groupIdNormalized + this.artifactId + "/";
    }

    public String getBaseUrl(String versionId) {
        return this.artifactory.server + "/" + this.artifactory.storage + "/" + this.groupIdNormalized + this.artifactId + "/" + versionId + "/";
    }

    public String getArtifactUrl(String versionId, String snapshotVersionId, String artifactClassifier, String extension) {
        if (StringUtils.isNotEmpty((CharSequence)artifactClassifier)) {
            return this.getBaseUrl(versionId) + this.artifactId + "-" + snapshotVersionId + "-" + artifactClassifier + "." + extension;
        }
        return this.getBaseUrl(versionId) + this.artifactId + "-" + snapshotVersionId + "." + extension;
    }

    public String getArtifactUrl(String versionId, Snapshot snapshot) {
        return this.getArtifactUrl(versionId, snapshot.getSnapshotId(), snapshot.getClassifier(), snapshot.getExtension());
    }

    public String getReleaseArtifactUrl(String versionId, SnapshotFilter descriptor) {
        return this.getArtifactUrl(versionId, versionId, descriptor.getClassifier(), descriptor.getExtension());
    }

    public String getSnapshotArtifactUrl(String versionId, SnapshotFilter descriptor) {
        String snapshotVersion = ResourceLocator.getSnapshotFromVersion(versionId);
        return this.getArtifactUrl(snapshotVersion, versionId, descriptor.getClassifier(), descriptor.getExtension());
    }

    public static String getSnapshotFromVersion(String versionId) {
        return versionId.replaceAll(SNAPSHOT_VERSION_EXTRACTION_PATTERN, "$1-SNAPSHOT");
    }

    public String toString() {
        return "ResourceLocator [artifactory=" + String.valueOf(this.artifactory) + ", kind=" + String.valueOf((Object)this.kind) + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + "]";
    }
}

