/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.confluence;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authentication.UsernamePasswordCredentials;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientSession;
import java.nio.file.Path;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.qubership.itool.modules.confluence.ConfluenceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceClientImpl
implements ConfluenceClient {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceClientImpl.class);
    private WebClient client;
    private Vertx vertx;
    private JsonObject config;
    private WebClientSession session;
    private Credentials credentials;

    protected ConfluenceClientImpl(Vertx vertx, WebClient client, JsonObject config) {
        this.vertx = vertx;
        this.client = client;
        this.config = config;
        this.credentials = new UsernamePasswordCredentials(config.getString("login"), config.getString("password"));
        this.session = WebClientSession.create((WebClient)client);
    }

    @Override
    public Future<JsonObject> updateConfluencePage(String spaceKey, String title, String parentTitle, String filePath, String release) {
        LOG.info("Sending page '{}' stored in '{}' to Confluence", (Object)title, (Object)filePath);
        Future futureConfluencePageInfo = this.getConfluencePageInfo(spaceKey, title, release).recover(pageInfo -> {
            LOG.debug("'{}': Page was not found, searching for the parent '{}' and create the new one", (Object)title, (Object)parentTitle);
            return this.getConfluencePageInfo(spaceKey, parentTitle, release).compose(parent -> this.createConfluencePage(spaceKey, title, parent.getString("id"), release));
        });
        Future futureStorageFileContents = this.readFile(filePath).compose(wikiFileContent -> this.convertWikiToStorage((String)wikiFileContent, title).compose(storageContent -> this.saveFile(this.buildStorageFileName(filePath), (String)storageContent).recover(e -> {
            LOG.warn("Failed to save contents in storage format to file {}: {}", (Object)this.buildStorageFileName(filePath), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return Future.succeededFuture((Object)storageContent);
        })));
        Future futureResponse = Future.join((Future)futureConfluencePageInfo, (Future)futureStorageFileContents).compose(compositeFuture -> {
            Future<JsonObject> parentFuture;
            JsonObject confluencePageInfo = (JsonObject)futureConfluencePageInfo.result();
            String storageFileContents = (String)futureStorageFileContents.result();
            JsonArray ancestors = confluencePageInfo.getJsonArray("ancestors");
            JsonObject parentPage = ancestors.getJsonObject(ancestors.size() - 1);
            if (this.buildPageTitle(parentTitle, release).equals(parentPage.getString("title"))) {
                parentFuture = Future.succeededFuture((Object)parentPage);
            } else {
                LOG.debug("'{}': Parent page didn't match, finding the related parent with title '{}'", (Object)title, (Object)parentTitle);
                parentFuture = this.getConfluencePageInfo(spaceKey, parentTitle, release);
            }
            return parentFuture.compose(parent -> this.uploadConfluencePageAsStorage(confluencePageInfo, parent.getString("id"), storageFileContents));
        }, fail -> Future.failedFuture((String)("Failed to upload the content of '" + title + "' page, reason: " + fail.getMessage())));
        return futureResponse;
    }

    private String buildStorageFileName(String path) {
        Path fullPath = Path.of(path, new String[0]);
        String fileName = fullPath.getFileName().toString().replaceFirst("\\.\\w+", "") + "_storage.xml";
        return fullPath.subpath(0, fullPath.getNameCount() - 1).resolve(fileName).toString();
    }

    @Override
    public Future<JsonObject> updateConfluencePage(JsonObject page, String release) {
        String spaceKey = page.getString("space");
        String title = page.getString("title");
        String parentTitle = page.getString("parentTitle");
        String onDiskPath = page.getString("onDiskPath");
        return this.updateConfluencePage(spaceKey, title, parentTitle, onDiskPath, release);
    }

    @Override
    public Future<JsonObject> createOrMoveConfluencePage(String spaceKey, String title, String parentId, String release) {
        Future future = this.getConfluencePageInfo(spaceKey, title, release).compose(page -> this.moveConfluencePage((JsonObject)page, parentId, release), res -> this.createConfluencePage(spaceKey, title, parentId, release));
        return future;
    }

    @Override
    public Future<JsonObject> createConfluencePage(String spaceKey, String title, String parentId, String release) {
        String finalTitle = this.buildPageTitle(title, release);
        JsonObject request = this.buildPageCreateRequestBody(finalTitle, spaceKey, parentId);
        LOG.info("Attempting to create the page '{}'", (Object)finalTitle);
        return this.session.post(443, this.config.getString("confluenceUrl"), "/rest/api/content").followRedirects(true).ssl(Boolean.valueOf(true)).authentication(this.credentials).sendJsonObject(request).compose(rsp -> {
            LOG.debug("Creation of page '{}' finished", (Object)finalTitle);
            if (200 != rsp.statusCode()) {
                return Future.failedFuture((String)("Can't create confluence page: " + rsp.bodyAsString()));
            }
            return Future.succeededFuture((Object)rsp.bodyAsJsonObject());
        });
    }

    @Override
    public Future<JsonArray> getChildPages(String spaceKey, String pageId) {
        LOG.debug("Getting child pages for page with id={}", (Object)pageId);
        Future<JsonArray> future = this.getChunkedList(spaceKey, "/rest/api/content/" + pageId + "/child/page");
        return future;
    }

    private Future<JsonArray> getChunkedList(String spaceKey, String url) {
        Future arrayFuture = Future.future(promise -> this.getNextChunk(url).onSuccess(body -> {
            JsonArray children = body.getJsonArray("results");
            if (!body.getJsonObject("_links").containsKey("next")) {
                promise.complete((Object)children);
                return;
            }
            String next = body.getJsonObject("_links").getString("next");
            LOG.trace("More pages present, loading next: {}", (Object)next);
            this.getChunkedList(spaceKey, next).onSuccess(nextChildren -> {
                children.addAll(nextChildren);
                promise.complete((Object)children);
            });
        }));
        return arrayFuture;
    }

    private Future<JsonObject> getNextChunk(String next) {
        LOG.trace("Getting next batch of pages from {}", (Object)next);
        Future future = this.session.get(443, this.config.getString("confluenceUrl"), next).followRedirects(true).ssl(Boolean.valueOf(true)).authentication(this.credentials).addQueryParam("expand", "version").send().compose(response -> {
            if (200 != response.statusCode()) {
                return Future.failedFuture((String)("Can't receive pages from " + next + " from Confluence: " + response.statusMessage()));
            }
            return Future.succeededFuture((Object)response.bodyAsJsonObject());
        });
        return future;
    }

    private JsonObject buildPageCreateRequestBody(String title, String space, String parentId) {
        JsonObject requestBody = new JsonObject().put("type", (Object)"page").put("title", (Object)title).put("space", (Object)new JsonObject().put("key", (Object)space)).put("ancestors", (Object)new JsonArray().add((Object)new JsonObject().put("id", (Object)parentId)));
        return requestBody;
    }

    @Override
    public Future<JsonObject> moveConfluencePage(JsonObject page, String newParentId, String release) {
        String finalTitle = page.getString("title");
        LOG.info("Attempting to move the page '{}' to new parent with id={}", (Object)finalTitle, (Object)newParentId);
        JsonObject request = this.buildPageMoveRequestBody(finalTitle, newParentId, page.getJsonObject("version").getInteger("number"));
        Future future = this.session.put(443, this.config.getString("confluenceUrl"), "/rest/api/content/" + page.getString("id")).followRedirects(true).ssl(Boolean.valueOf(true)).authentication(this.credentials).sendJsonObject(request).compose(rsp -> {
            LOG.debug("Movement of page '{}' finished", (Object)finalTitle);
            if (200 != rsp.statusCode()) {
                return Future.failedFuture((String)("Can't move Confluence page '" + page.getString("title") + "': " + rsp.bodyAsString()));
            }
            return Future.succeededFuture((Object)rsp.bodyAsJsonObject());
        });
        return future;
    }

    private JsonObject buildPageMoveRequestBody(String title, String parentId, Integer version) {
        JsonObject requestBody = new JsonObject().put("type", (Object)"page").put("title", (Object)title).put("ancestors", (Object)new JsonArray().add((Object)new JsonObject().put("id", (Object)parentId))).put("version", (Object)new JsonObject().put("number", (Object)(version + 1)));
        return requestBody;
    }

    @Override
    public Future<String> convertWikiToStorage(String wikiContent, String title) {
        LOG.info("Converting the wiki format for '{}' into storage format", (Object)title);
        JsonObject request = new JsonObject().put("value", (Object)wikiContent).put("representation", (Object)"wiki");
        Future future = this.session.post(443, this.config.getString("confluenceUrl"), "/rest/api/contentbody/convert/storage").followRedirects(true).ssl(Boolean.valueOf(true)).authentication(this.credentials).sendJsonObject(request).compose(rsp -> {
            LOG.trace("Conversion of page '{}' finished", (Object)title);
            if (200 != rsp.statusCode()) {
                return Future.failedFuture((String)("Can't convert wiki page '" + title + "' to storage format, response: " + rsp.bodyAsString()));
            }
            return Future.succeededFuture((Object)rsp.bodyAsJsonObject().getString("value"));
        });
        return future;
    }

    @Override
    public Future<JsonObject> getConfluencePageInfo(String spaceKey, String title) {
        return this.getConfluencePageInfo(spaceKey, title, null);
    }

    @Override
    public Future<JsonObject> getConfluencePageInfo(String spaceKey, String title, String release) {
        String finalTitle = this.buildPageTitle(title, release);
        LOG.debug("Retrieving detailed page information from Confluence for page '{}'", (Object)finalTitle);
        Future future = this.client.get(443, this.config.getString("confluenceUrl"), "/rest/api/content").addQueryParam("spaceKey", spaceKey).addQueryParam("title", finalTitle).addQueryParam("expand", "version,ancestors").ssl(Boolean.valueOf(true)).authentication(this.credentials).send().compose(response -> {
            LOG.trace("Detailed page retrieval for '{}' finished", (Object)finalTitle);
            if (200 != response.statusCode()) {
                return Future.failedFuture((String)("Can't receive page info for '" + finalTitle + "' from Confluence: " + response.statusCode() + ":" + response.statusMessage()));
            }
            JsonObject confluencePageInfoJson = response.bodyAsJsonObject();
            if (confluencePageInfoJson.getJsonArray("results").size() == 1) {
                return Future.succeededFuture((Object)confluencePageInfoJson.getJsonArray("results").getJsonObject(0));
            }
            if (confluencePageInfoJson.getJsonArray("results").size() > 1) {
                return Future.failedFuture((String)("Found more than one page with a spaceKey=" + spaceKey + " and title='" + finalTitle + "'"));
            }
            return Future.failedFuture((String)("Page '" + finalTitle + "' was not found in Confluence"));
        });
        return future;
    }

    @Override
    public Future<JsonObject> getConfluencePageInfo(String pageId) {
        LOG.info("Retrieving detailed page information from Confluence for page with id={}", (Object)pageId);
        Future future = this.client.get(443, this.config.getString("confluenceUrl"), "/rest/api/content/" + pageId).addQueryParam("expand", "version,ancestors").ssl(Boolean.valueOf(true)).authentication(this.credentials).send().compose(response -> {
            if (200 != response.statusCode()) {
                return Future.failedFuture((String)("Failed to retrieve info for page id=" + pageId + " from Confluence: " + response.bodyAsString()));
            }
            return Future.succeededFuture((Object)response.bodyAsJsonObject());
        });
        return future;
    }

    private String buildPageTitle(String title, String release) {
        return release == null ? title : release + " " + title;
    }

    @Override
    public Future<JsonObject> uploadConfluencePageAsStorage(JsonObject page, String parentId, String storageContent) {
        LOG.debug("Uploading page '{}' with id {} and parentId {} in storage format.", new Object[]{page.getString("title"), page.getString("id"), parentId});
        JsonObject requestBody = this.buildUpdateRequestBody(page, parentId, storageContent);
        Future future = this.client.put(443, this.config.getString("confluenceUrl"), "/rest/api/content/" + page.getString("id")).authentication(this.credentials).ssl(Boolean.valueOf(true)).followRedirects(true).sendJsonObject(requestBody).compose(rsp -> {
            if (200 != rsp.statusCode()) {
                return Future.failedFuture((String)("Page update failed for page '" + page.getString("title") + "': " + rsp.bodyAsString()));
            }
            LOG.debug("Uploading of page '{}' with storage format finished", (Object)page.getString("title"));
            return Future.succeededFuture((Object)rsp.bodyAsJsonObject());
        });
        return future;
    }

    private JsonObject buildUpdateRequestBody(JsonObject page, String parentId, String storageContent) {
        JsonObject requestBody = new JsonObject().put("type", (Object)"page").put("title", (Object)page.getString("title")).put("version", (Object)new JsonObject().put("number", (Object)(page.getJsonObject("version").getInteger("number") + 1))).put("body", (Object)new JsonObject().put("storage", (Object)new JsonObject().put("value", (Object)storageContent).put("representation", (Object)"storage")));
        if (parentId != null) {
            requestBody.put("ancestors", (Object)new JsonArray().add((Object)new JsonObject().put("id", (Object)parentId)));
        }
        return requestBody;
    }

    private Future<String> readFile(String path) {
        LOG.trace("Reading file contents of {}", (Object)path);
        Future future = this.vertx.fileSystem().readFile(path).compose(res -> {
            LOG.trace("Reading of file '{}' finished", (Object)path);
            return Future.succeededFuture((Object)res.toString());
        }, fail -> Future.failedFuture((String)("Reading of file " + path + " failed: " + fail.getCause().getMessage())));
        return future;
    }

    private Future<String> saveFile(String path, String content) {
        LOG.trace("Saving file contents of {}", (Object)path);
        Future future = this.vertx.fileSystem().writeFile(path, Buffer.buffer((String)content)).compose(res -> {
            LOG.trace("Saving of file '{}' finished", (Object)path);
            return Future.succeededFuture((Object)content);
        }, fail -> Future.failedFuture((String)("Saving of file " + path + " failed: " + fail.getCause().getMessage())));
        return future;
    }
}

