/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.providers.DiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;

public abstract class AbstractQueueDiagramProvider
implements DiagramProvider {
    private Properties properties;
    static final String QUEUE_STRING = "queue \"";
    static final String RECTANGLE_STRING = "rectangle \"";

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public String header(BasicGraph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append("@startuml\n\n");
        builder.append("scale 0.8\n");
        builder.append("left to right direction\n");
        builder.append("skinparam defaultTextAlignment center\n\n");
        builder.append("skinparam queueBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.queue", "GreenYellow")).append("\n");
        builder.append("skinparam rectangleBackgroundColor ").append(this.getProperties().getProperty("diagram.skinparam.backgroundColor.default.component", "Yellow")).append("\n");
        return builder.toString();
    }

    @Override
    public String footer(BasicGraph graph) {
        return "\n@enduml\n";
    }

    protected String generateGraphSchema(Diagram diagram, BasicGraph graph) {
        String queueName;
        StringBuilder relationBuilder = new StringBuilder();
        StringBuilder builder = new StringBuilder();
        builder.append(this.header(graph));
        ArrayList<String> producersNames = new ArrayList<String>();
        ArrayList<String> consumersNames = new ArrayList<String>();
        ArrayList<String> queueNames = new ArrayList<String>();
        for (Map<String, Object> singleProducer : diagram.getProducerList()) {
            String producerName;
            queueName = singleProducer.get("queueName").toString();
            if (!queueNames.contains(queueName)) {
                queueNames.add(queueName);
            }
            if (!producersNames.contains(producerName = singleProducer.get("producerName").toString())) {
                producersNames.add(producerName);
            }
            if (this.queueHasDualLinkToComponent(diagram.getConsumerList(), queueName, producerName, "consumerName").booleanValue()) {
                relationBuilder.append(this.charReplace(queueName)).append(" <-[#deepSkyBlue]-> ").append(this.charReplace(producerName)).append(": ").append(queueName).append("\n");
                continue;
            }
            relationBuilder.append(this.charReplace(producerName)).append(" -[#green]-> ").append(this.charReplace(queueName)).append(": <<producer>> ").append(queueName).append("\n");
        }
        for (Map<String, Object> singleConsumer : diagram.getConsumerList()) {
            queueName = singleConsumer.get("queueName").toString();
            String consumerName = singleConsumer.get("consumerName").toString();
            if (this.queueHasDualLinkToComponent(diagram.getProducerList(), queueName, consumerName, "producerName").booleanValue()) continue;
            relationBuilder.append(this.charReplace(queueName)).append(" -[#blue]-> ").append(this.charReplace(consumerName)).append(": <<consumer>> ").append(queueName).append("\n");
            if (!consumersNames.contains(consumerName)) {
                consumersNames.add(consumerName);
            }
            if (queueNames.contains(queueName)) continue;
            queueNames.add(queueName);
        }
        builder.append(this.mappingBuilder(queueNames, QUEUE_STRING));
        builder.append(this.mappingBuilder(producersNames, RECTANGLE_STRING));
        builder.append(this.mappingBuilder(consumersNames, RECTANGLE_STRING));
        builder.append((CharSequence)relationBuilder);
        builder.append(this.footer(graph));
        return builder.toString();
    }

    private String mappingBuilder(List<String> nameList, String type) {
        StringBuilder builder = new StringBuilder();
        if (type.equals(QUEUE_STRING)) {
            for (String data : nameList) {
                builder.append(type).append(this.charReplace(data)).append("\" as ").append(this.charReplace(data)).append("\n");
            }
        } else {
            for (String data : nameList) {
                builder.append(type).append(data).append("\" as ").append(this.charReplace(data)).append("\n");
            }
        }
        return builder.toString();
    }

    protected String charReplace(String str) {
        return str.replaceAll("/|\\s|&|:|\\$\\{.+\\:(.+)\\}|\\(\\)|\\$\\{.+\\}", "$1").replaceAll("\\_+(.+)", "$1").replaceAll("(\\w)\\_*", "$1").replaceAll("\\s", "").replaceAll("\\(.+\\)", "").replaceAll("\\-", "_").replaceAll("\\.", "_").replaceAll("\\_(.+)", "$1").replaceAll("(.+)\\_", "$1").replaceAll("\\#\\{.+\\}(.+)", "$1");
    }

    protected Boolean queueHasDualLinkToComponent(List<Map<String, Object>> componentsList, String queueName, String checkedComponentName, String componentNameKey) {
        for (Map<String, Object> nextComponent : componentsList) {
            String nextQueueName = nextComponent.get("queueName").toString();
            String nextComponentName = nextComponent.get(componentNameKey).toString();
            if (!queueName.equals(nextQueueName) || !checkedComponentName.equals(nextComponentName)) continue;
            return true;
        }
        return false;
    }
}

