/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.providers.AbstractDiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;
import org.qubership.itool.modules.gremlin2.graph.__;

public class ApplicationMicroserviceDiagramProvider
extends AbstractDiagramProvider {
    @Override
    public String getType() {
        return "app-microservice";
    }

    @Override
    public String generate(DiagramService diagramService, BasicGraph graph, Diagram diagram) {
        BasicGraph subgraph;
        String[] componentIds = diagram.getComponentIds() == null ? new String[]{} : diagram.getComponentIds().toArray(new String[0]);
        GraphTraversal<JsonObject, JsonObject> traversal = graph.traversal().V(new String[0]).hasType("application");
        traversal.out(new String[0]);
        if (componentIds.length != 0) {
            traversal.hasId(componentIds);
        }
        if ((subgraph = (BasicGraph)traversal.union(__.inE(diagram.getSupportedEdges()).not(__.outV().hasType("application")).subgraph("G"), __.outE(diagram.getSupportedEdges()).as("outE", new String[0]).subgraph("G")).cap("G").next()) == null) {
            return null;
        }
        return this.generateApplicationGraphSchema(graph, diagram, subgraph);
    }

    protected String generateApplicationGraphSchema(BasicGraph graph, Diagram diagram, BasicGraph subgraph) {
        String id;
        List<JsonObject> fetchedVertices;
        if (subgraph == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        HashSet<String> entityList = new HashSet<String>();
        for (JsonObject vertex : subgraph.vertexList()) {
            fetchedVertices = this.fetchVertex(graph, vertex);
            for (JsonObject fetchedVertex : fetchedVertices) {
                if (fetchedVertex == null) continue;
                id = fetchedVertex.getString("id");
                String application = (String)graph.traversal().V(id).in(new String[0]).hasType("application").id().next();
                application = application == null ? fetchedVertex.getString("type") : application;
                entityList.add(id);
                entityList.add(application);
            }
        }
        this.buildHeader(builder, diagram, entityList);
        for (JsonObject vertex : subgraph.vertexList()) {
            fetchedVertices = this.fetchVertex(graph, vertex);
            for (JsonObject fetchedVertex : fetchedVertices) {
                if (fetchedVertex == null) continue;
                id = fetchedVertex.getString("id");
                String type = fetchedVertex.getString("type");
                String name = fetchedVertex.getString("name");
                String application = (String)graph.traversal().V(id).in(new String[0]).hasType("application").id().next();
                application = application == null ? fetchedVertex.getString("type") : application;
                builder.append(this.getComponentType(diagram, type));
                builder.append(" \"").append(name).append("\" ");
                if (diagram.getDefaultComponent() == null && application != null && !application.equals(diagram.getDefaultDomainLevelEntity()) || diagram.getDefaultComponent() != null && diagram.getDefaultDomainLevelEntity() != null && !id.equals(diagram.getDefaultComponent())) {
                    builder.append("<<").append(application).append(">> ");
                }
                builder.append(" as ").append(this.escape(id)).append("\n");
            }
        }
        builder.append("\n");
        for (JsonObject edge : subgraph.edgeList()) {
            String edgeId = edge.getString("id");
            String edgeType = edge.getString("type");
            List<Map<String, String>> sourceTargetPairs = this.getOptimizedSourceTarget(subgraph, graph, edgeId);
            for (Map<String, String> pair : sourceTargetPairs) {
                String source = pair.get("source");
                String target = pair.get("target");
                if (source == null || target == null) continue;
                builder.append(this.escape(source)).append(" ").append(this.getEdgeConnector(diagram, edgeType)).append(" ").append(this.escape(target)).append("\n");
            }
        }
        builder.append("\n");
        builder.append("@enduml\n");
        return this.removeDublicatesLine(builder);
    }
}

