/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.providers.AbstractDiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversal;

public class DomainDiagramProvider
extends AbstractDiagramProvider {
    @Override
    public String getType() {
        return "domain";
    }

    @Override
    public String generate(DiagramService diagramService, BasicGraph graph, Diagram diagram) {
        List<String> microserviceIds;
        List<String> componentIds;
        String department = diagram.getDepartment();
        String[] excludeDomains = diagram.getExcludeDomains() == null ? new String[]{} : diagram.getExcludeDomains();
        String[] domains = new String[]{};
        if (diagram.getDefaultDomainLevelEntity() != null) {
            domains = new String[]{diagram.getDefaultDomainLevelEntity()};
        }
        if (CollectionUtils.isNotEmpty(componentIds = diagram.getComponentIds())) {
            domains = componentIds.toArray(new String[componentIds.size()]);
        }
        GraphTraversal<JsonObject, JsonObject> traversal = graph.traversal().V(new String[0]).hasType("domain");
        if (department != null) {
            traversal.has("department", department);
        }
        if (excludeDomains.length != 0) {
            traversal.hasNotId(excludeDomains);
        }
        if (domains.length != 0) {
            traversal.hasId(domains);
        }
        if ((microserviceIds = traversal.out(new String[0]).id().toList()).isEmpty()) {
            return null;
        }
        diagram.setComponentIds(microserviceIds);
        return diagramService.generate("microservice", diagram);
    }
}

