/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.diagram.providers;

import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.itool.modules.diagram.Diagram;
import org.qubership.itool.modules.diagram.DiagramService;
import org.qubership.itool.modules.diagram.providers.AbstractDiagramProvider;
import org.qubership.itool.modules.graph.BasicGraph;

public class InfrastructureDiagramProvider
extends AbstractDiagramProvider {
    @Override
    public String getType() {
        return "infrastructure";
    }

    @Override
    public String generate(DiagramService diagramService, BasicGraph graph, Diagram diagram) {
        String relation;
        JsonObject component;
        JsonObject infraComponent;
        String[] entityIds = diagram.getComponentIds().toArray(new String[0]);
        List jsonList = graph.traversal().V("Infra").out(new String[0]).hasId(entityIds).as("infraComponent", new String[0]).outE(new String[0]).as("outEdge", new String[0]).inV().as("component", new String[0]).select("infraComponent", "outEdge", "component").toList();
        HashSet<String> microservicesSet = new HashSet<String>();
        HashSet<String> edgesSet = new HashSet<String>();
        StringBuilder result = new StringBuilder();
        for (Map map : jsonList) {
            infraComponent = (JsonObject)map.get("infraComponent");
            JsonObject outEdge = (JsonObject)map.get("outEdge");
            component = (JsonObject)map.get("component");
            microservicesSet.add(this.component(null, infraComponent));
            microservicesSet.add(this.component(null, component));
            relation = this.relation(infraComponent.getString("id"), component.getString("id"), outEdge.getString("type"), outEdge.getString("name"), false);
            edgesSet.add(relation);
        }
        jsonList = graph.traversal().V("Infra").out(new String[0]).hasId(entityIds).as("infraComponent", new String[0]).inE(new String[0]).as("inEdge", new String[0]).outV().hasNotId("Infra").as("component", new String[0]).select("infraComponent", "inEdge", "component").toList();
        for (Map map : jsonList) {
            infraComponent = (JsonObject)map.get("infraComponent");
            JsonObject inEdge = (JsonObject)map.get("inEdge");
            component = (JsonObject)map.get("component");
            microservicesSet.add(this.component(null, infraComponent));
            microservicesSet.add(this.component(null, component));
            relation = this.relation(component.getString("id"), infraComponent.getString("id"), inEdge.getString("type"), inEdge.getString("name"), false);
            edgesSet.add(relation);
        }
        for (String m : microservicesSet) {
            result.append(m).append("\n");
        }
        result.append("\n");
        for (String m : edgesSet) {
            result.append(m).append("\n");
        }
        String r = result.toString();
        r = Arrays.asList(r.split("\n")).stream().distinct().collect(Collectors.joining("\n"));
        return this.header(graph) + r + this.footer(graph);
    }
}

