/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.git;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import javax.annotation.Nullable;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitAdapterImpl;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitAdapterBuilder {
    protected static final Logger LOG = LoggerFactory.getLogger(GitAdapterBuilder.class);

    @Nullable
    public static GitAdapter create(Vertx vertx, GraphReport report, JsonObject config) {
        boolean offlineMode = Boolean.parseBoolean(config.getString("offlineMode"));
        if (offlineMode) {
            LOG.warn("Offline mode, GIT facilities will not be available");
            return null;
        }
        String password = config.getString("password");
        String login = config.getString("login");
        if (login == null || password == null) {
            LOG.warn("No login or password provided, GIT facilities will not be available");
            return null;
        }
        return new GitAdapterImpl(vertx, report, config);
    }
}

