/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.git;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.eclipse.jgit.api.Git;
import org.qubership.itool.modules.git.GitAdapter;
import org.qubership.itool.modules.git.GitFileRetriever;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitFileRetrieverImpl
implements GitFileRetriever {
    protected static final Logger LOG = LoggerFactory.getLogger(GitFileRetrieverImpl.class);
    private GitAdapter gitAdapter;
    private JsonObject config;
    private Vertx vertx;
    private GraphReport report;

    public GitFileRetrieverImpl(GitAdapter gitAdapter, JsonObject config, Vertx vertx, GraphReport report) {
        this.gitAdapter = gitAdapter;
        this.config = config;
        this.vertx = vertx;
        this.report = report;
    }

    @Override
    public Future<?> copyFilesFromReleases(String sourceRelease, String targetRelease, List<Path> files) {
        return this.gitAdapter.openSuperrepository().compose(repo -> this.gitAdapter.branchCheckout((Git)repo, sourceRelease).compose(r -> {
            List<Future<?>> copyFutures = this.copyFilesFromRepo((Git)repo, sourceRelease, files);
            return Future.join(copyFutures);
        }).compose(r -> this.gitAdapter.branchCheckout((Git)repo, targetRelease).onFailure(e -> this.report.internalError("Failed to checkout branch " + targetRelease + ": " + ExceptionUtils.getStackTrace((Throwable)e))).compose(res -> {
            List<Future<?>> copyFutures = this.copyFilesFromRepo((Git)repo, targetRelease, files);
            return Future.join(copyFutures).onFailure(e -> this.report.internalError("Some files were not copied: " + ExceptionUtils.getStackTrace((Throwable)e)));
        })).onComplete(r -> repo.close()));
    }

    @Override
    public Future<Triple<Path, String, String>> getFileInfo(String sourceRelease, String targetRelease, Path path) {
        String sourcePath = this.buildDiffOutputPath(sourceRelease, path).toString();
        String targetPath = this.buildDiffOutputPath(targetRelease, path).toString();
        Future sourceFuture = this.vertx.fileSystem().readFile(sourcePath).map(v -> v.toString()).recover(r -> Future.succeededFuture((Object)new JsonObject().put("warning", (Object)(sourcePath + " file was not found")).encodePrettily()));
        Future targetFuture = this.vertx.fileSystem().readFile(targetPath).map(v -> v.toString()).recover(r -> Future.succeededFuture((Object)new JsonObject().put("warning", (Object)(targetPath + " file was not found")).encodePrettily()));
        Future result = Future.join((Future)sourceFuture, (Future)targetFuture).map(r -> Triple.of((Object)path, (Object)((String)sourceFuture.result()), (Object)((String)targetFuture.result())));
        return result;
    }

    @Override
    public List<Future<?>> copyFilesFromRepo(Git repo, String release, List<Path> files) {
        ArrayList copyFutures = new ArrayList();
        for (Path path : files) {
            Future futureFile = this.copyFromRepo(repo, release, path).recover(e -> {
                this.report.internalError("Couldn't copy file " + path.toString() + " from repository " + String.valueOf(repo.getRepository().getDirectory()) + ": " + ExceptionUtils.getStackTrace((Throwable)e));
                return Future.succeededFuture();
            });
            copyFutures.add(futureFile);
        }
        return copyFutures;
    }

    private Future<Void> copyFromRepo(Git repo, String release, Path basePath) {
        Path repoPath = this.buildRepoPath(repo, basePath);
        Path newPath = this.buildDiffOutputPath(release, basePath);
        return this.copyWithParents(repoPath, newPath);
    }

    private Future<Void> copyWithParents(Path from, Path to) {
        return this.vertx.fileSystem().exists(to.getParent().toString()).compose(r -> {
            if (!r.booleanValue()) {
                return this.vertx.fileSystem().mkdirs(to.getParent().toString());
            }
            return Future.succeededFuture();
        }).compose(r -> this.vertx.fileSystem().copy(from.toString(), to.toString()));
    }

    @Override
    public Path buildRepoPath(Git repo, Path basePath) {
        return repo.getRepository().getDirectory().toPath().getParent().resolve(basePath);
    }

    @Override
    public Path buildDiffOutputPath(String release, Path basePath) {
        return Path.of("output", "diff", release, basePath.getFileName().toString());
    }

    private Future<Map<Path, String>> getFilesFromRepository(List<Path> files, Git repo) {
        Future result = Future.future(p -> {
            HashMap<Path, Future> filesContents = new HashMap<Path, Future>();
            HashMap endResult = new HashMap();
            Path repoPath = repo.getRepository().getDirectory().toPath().getParent();
            for (Path path : files) {
                Future futureFile = this.vertx.fileSystem().readFile(repoPath.resolve(path).toString()).map(v -> v.toString());
                filesContents.put(path, futureFile);
            }
            Future.join(filesContents.values().stream().collect(Collectors.toList())).onComplete(r -> {
                for (Path path : filesContents.keySet()) {
                    if (((Future)filesContents.get(path)).succeeded()) {
                        endResult.put(path, (String)((Future)filesContents.get(path)).result());
                        continue;
                    }
                    endResult.put(path, null);
                }
                p.complete((Object)endResult);
            });
        });
        return result;
    }
}

