/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphImpl;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.modules.report.GraphReportImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphDumpSupport {
    private static final Logger LOG = LoggerFactory.getLogger(GraphDumpSupport.class);
    public static final int CURRENT_CONTAINER_MODEL_VERSION = 1;
    public static final int LEGACY_CONTAINER_MODEL_VERSION = -1;
    public static final int NO_GRAPH_MODEL_VERSION = -2;
    public static final int LEGACY_GRAPH_MODEL_VERSION = -1;
    public static final int NO_REPORT_MODEL_VERSION = -2;
    public static final int LEGACY_REPORT_MODEL_VERSION = -1;

    public static JsonObject dumpToJson(Graph graph, boolean deepCopy) {
        JsonObject dump = new JsonObject();
        dump.put("modelVersion", (Object)1);
        dump.put("graph", (Object)graph.dumpGraphData(deepCopy));
        GraphReport report = graph.getReport();
        if (report != null) {
            dump.put("report", (Object)report.dumpReportData(deepCopy));
        }
        return dump;
    }

    public static void restoreFromJson(Graph target, JsonObject dump) {
        if (dump == null) {
            throw new NullPointerException("dump is null");
        }
        JsonObject graphDump = dump.getJsonObject("graph");
        if (graphDump == null) {
            throw new NullPointerException("dump.graph is null");
        }
        target.restoreGraphData(graphDump);
        Integer modelVersion = dump.getInteger("modelVersion");
        Object rawReportDump = dump.getValue("report");
        if (rawReportDump != null) {
            JsonObject reportDump;
            GraphReport report = target.getReport();
            if (report == null) {
                report = new GraphReportImpl();
                target.setReport(report);
            }
            if (modelVersion == null && rawReportDump instanceof JsonArray) {
                reportDump = new JsonObject().put("modelVersion", (Object)1).put("records", rawReportDump);
            } else if (modelVersion != null && modelVersion == 1 && rawReportDump instanceof JsonObject) {
                reportDump = (JsonObject)rawReportDump;
            } else {
                LOG.error("Invalid or unsupported report format, skipping");
                reportDump = new JsonObject().put("modelVersion", (Object)1).put("records", (Object)new JsonArray());
            }
            report.restoreReportData(reportDump);
        }
    }

    public static Graph restoreFromJson(JsonObject dump) {
        GraphImpl graph = new GraphImpl();
        GraphDumpSupport.restoreFromJson(graph, dump);
        return graph;
    }

    public static int getDumpModelVersion(JsonObject dump) {
        return dump.getInteger("modelVersion", Integer.valueOf(-1));
    }

    public static int getGraphModelVersion(JsonObject dump) {
        JsonObject graph = dump.getJsonObject("graph");
        if (graph == null) {
            return -2;
        }
        return graph.getInteger("modelVersion", Integer.valueOf(-1));
    }

    public static boolean isGraphDumpSupported(JsonObject dump) {
        int dumpModelVersion = GraphDumpSupport.getDumpModelVersion(dump);
        int graphModelVersion = GraphDumpSupport.getGraphModelVersion(dump);
        return (dumpModelVersion == 1 || dumpModelVersion == -1) && graphModelVersion <= 3;
    }

    public static int getErrorReportModelVersion(JsonObject dump) {
        int containerVersion = GraphDumpSupport.getDumpModelVersion(dump);
        switch (containerVersion) {
            case -1: {
                JsonArray report = dump.getJsonArray("report");
                if (report != null) {
                    return -1;
                }
            }
            case 1: {
                JsonArray report = dump.getJsonObject("report");
                if (report == null) break;
                return report.getInteger("modelVersion", Integer.valueOf(-1));
            }
        }
        return -2;
    }

    public static JsonArray getErrorReportRecords(JsonObject dump) {
        int reportVersion = GraphDumpSupport.getErrorReportModelVersion(dump);
        switch (reportVersion) {
            case -1: {
                return (JsonArray)JsonPointer.from((String)"/report").queryJson((Object)dump);
            }
            case 1: {
                return (JsonArray)JsonPointer.from((String)"/report/records").queryJson((Object)dump);
            }
            case -2: {
                LOG.error("No error report");
                return null;
            }
        }
        LOG.error("Unrecognized dump version");
        return null;
    }
}

