/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.artifactory.AppVersionDescriptor;
import org.qubership.itool.modules.artifactory.GraphSnapshot;
import org.qubership.itool.modules.graph.GraphClassifier;

public interface GraphFetcher {
    default public AppVersionDescriptor resolveAppVersion(String appVersionId) {
        return null;
    }

    default public Map<String, AppVersionDescriptor> resolveAppVersions(Collection<String> appVersionIds) {
        LinkedHashMap<String, AppVersionDescriptor> result = new LinkedHashMap<String, AppVersionDescriptor>();
        for (String appVersionId : appVersionIds) {
            AppVersionDescriptor desc = this.resolveAppVersion(appVersionId);
            result.put(appVersionId, desc);
        }
        return result;
    }

    default public GraphSnapshot fetchGraphDumpByAppVersion(AppVersionDescriptor appVersionDesc) {
        return null;
    }

    default public Map<AppVersionDescriptor, GraphSnapshot> fetchGraphDumpsByAppVersions(Collection<AppVersionDescriptor> appVersions) {
        LinkedHashMap<AppVersionDescriptor, GraphSnapshot> result = new LinkedHashMap<AppVersionDescriptor, GraphSnapshot>();
        for (AppVersionDescriptor appVersion : appVersions) {
            GraphSnapshot graphSnapshot = this.fetchGraphDumpByAppVersion(appVersion);
            result.put(appVersion, graphSnapshot);
        }
        return result;
    }

    default public GraphClassifier resolveGraphClassifier(String graphClassifierId) {
        return null;
    }

    default public GraphSnapshot fetchGraphDumpByClassifier(GraphClassifier classifier) {
        return null;
    }

    default public boolean persistGraphByClassifier(GraphClassifier graphClassifier, GraphSnapshot graphSnapshot, Map<AppVersionDescriptor, GraphSnapshot> sources, Map<AppVersionDescriptor, GraphSnapshot> unprocessedAppIds) {
        return false;
    }

    default public List<AppVersionDescriptor> fetchAllApplicationVersionIds(GraphClassifier graphClassifier) {
        return null;
    }
}

