/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.qubership.itool.modules.graph.Edge;
import org.qubership.itool.modules.graph.EdgeImpl;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.Vertex;
import org.qubership.itool.modules.graph.VertexImpl;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;
import org.qubership.itool.modules.processor.InvalidGraphException;
import org.qubership.itool.modules.report.GraphReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphImpl
implements Graph {
    private static final Logger LOG = LoggerFactory.getLogger(GraphImpl.class);
    private int graphVersion;
    private Map<String, Vertex> vertices;
    private Map<String, Edge> edges;
    private int edgeGeneratorCounter;
    private GraphReport report;

    public GraphImpl() {
        this.clear();
        this.graphVersion = 3;
    }

    @Override
    public GraphTraversalSource traversal() {
        return new GraphTraversalSource(this);
    }

    @Override
    public synchronized JsonObject getVertex(String vertexId) {
        if (!this.vertices.containsKey(vertexId)) {
            return null;
        }
        return this.vertices.get(vertexId).getValue();
    }

    @Override
    public synchronized boolean addVertex(JsonObject vertex) {
        String vertexId = vertex.getString("id");
        if (vertexId == null || this.vertices.containsKey(vertexId)) {
            return false;
        }
        VertexImpl vertexObj = new VertexImpl(vertexId, vertex);
        this.vertices.put(vertexId, vertexObj);
        return true;
    }

    @Override
    public synchronized boolean addVertex(String sourceVertexId, JsonObject destinationVertex) {
        JsonObject sourceVertex = this.getVertex(sourceVertexId);
        if (sourceVertex == null) {
            return false;
        }
        return this.addVertex(sourceVertex, destinationVertex);
    }

    @Override
    public synchronized boolean addVertex(JsonObject sourceVertex, JsonObject destinationVertex) {
        String srcVertexId = sourceVertex.getString("id");
        String destVertexId = destinationVertex.getString("id");
        if (srcVertexId == null || destVertexId == null || !this.vertices.containsKey(srcVertexId) || this.vertices.containsKey(destVertexId)) {
            return false;
        }
        this.addVertex(destinationVertex);
        this.addEdge(sourceVertex, destinationVertex, null);
        return true;
    }

    @Override
    public synchronized boolean addVertexUnderRoot(JsonObject vertex) {
        String vertexId = vertex.getString("id");
        if (vertexId == null || this.vertices.containsKey(vertexId)) {
            return false;
        }
        this.addVertex(vertex);
        this.addEdge(this.getVertex("root"), vertex, null);
        return true;
    }

    @Override
    public synchronized boolean relocateVertex(JsonObject vertex, String newId) {
        String oldId = vertex.getString("id");
        if (oldId == null || !this.vertices.containsKey(oldId) || this.vertices.containsKey(newId)) {
            return false;
        }
        LOG.debug("Relocating vertex {} to {}", (Object)oldId, (Object)newId);
        Vertex vertexObj = this.moveVertexToNewId(vertex, newId, oldId);
        for (String outgoingEdgeId : vertexObj.getEdgesOut()) {
            Edge outgoingEdge = this.edges.get(outgoingEdgeId);
            if (outgoingEdge == null) continue;
            LOG.debug(" - Edge {} changed its source", (Object)outgoingEdgeId);
            outgoingEdge.setSourceVertexId(newId);
        }
        for (String incomingEdgeId : vertexObj.getEdgesIn()) {
            Edge incomingEdge = this.edges.get(incomingEdgeId);
            if (incomingEdge == null) continue;
            LOG.debug(" - Edge {} changed its destination", (Object)incomingEdgeId);
            incomingEdge.setDestinationVertexId(newId);
        }
        return true;
    }

    private Vertex moveVertexToNewId(JsonObject vertex, String newId, String oldId) {
        Vertex oldVertexObj = this.vertices.get(oldId);
        this.vertices.remove(oldId);
        vertex.put("id", (Object)newId);
        this.addVertex(vertex);
        Vertex newVertexObj = this.vertices.get(newId);
        newVertexObj.getEdgesIn().addAll(oldVertexObj.getEdgesIn());
        newVertexObj.getEdgesOut().addAll(oldVertexObj.getEdgesOut());
        return oldVertexObj;
    }

    @Override
    public synchronized boolean removeVertex(JsonObject vertex) {
        String vertexId = vertex.getString("id");
        if (vertexId == null || !this.vertices.containsKey(vertexId)) {
            return false;
        }
        Vertex vertexObj = this.vertices.get(vertexId);
        for (String outgoingEdgeId : vertexObj.getEdgesOut()) {
            Edge outgoingEdge = this.edges.get(outgoingEdgeId);
            if (outgoingEdge == null) continue;
            String destinationVertexId = outgoingEdge.getDestinationVertexId();
            Vertex destinationVertex = this.vertices.get(destinationVertexId);
            destinationVertex.getEdgesIn().remove(outgoingEdgeId);
            this.edges.remove(outgoingEdgeId);
        }
        for (String incomingEdgeId : vertexObj.getEdgesIn()) {
            Edge incomingEdge = this.edges.get(incomingEdgeId);
            if (incomingEdge == null) continue;
            String edgeFrom = incomingEdge.getSourceVertexId();
            Vertex edgeSource = this.vertices.get(edgeFrom);
            edgeSource.getEdgesOut().remove(incomingEdgeId);
            this.edges.remove(incomingEdgeId);
        }
        return this.vertices.remove(vertexId) != null;
    }

    @Override
    public synchronized JsonObject getEdge(String edgeId) {
        if (!this.edges.containsKey(edgeId)) {
            return null;
        }
        return this.edges.get(edgeId).getValue();
    }

    @Override
    public synchronized String addEdge(JsonObject sourceVertex, JsonObject destinationVertex) {
        return this.addEdge(sourceVertex, destinationVertex, null);
    }

    @Override
    public synchronized String addEdge(JsonObject sourceVertex, JsonObject destinationVertex, JsonObject edge) {
        Vertex target;
        Vertex source;
        Set<String> allEdges;
        if (edge == null) {
            edge = new JsonObject();
            edge.put("id", (Object)this.generateEdgeId());
        } else if (this.edges.containsKey(edge.getString("id"))) {
            return null;
        }
        String edgeId = edge.getString("id");
        if (edgeId == null) {
            edgeId = this.generateEdgeId();
            edge.put("id", (Object)edgeId);
        }
        if (!this.vertices.containsKey(sourceVertex.getString("id"))) {
            this.addVertex(sourceVertex);
        }
        if (!this.vertices.containsKey(destinationVertex.getString("id"))) {
            this.addVertex(destinationVertex);
        }
        if (!(allEdges = this.getEdgeIdsBetween(source = this.vertices.get(sourceVertex.getString("id")), target = this.vertices.get(destinationVertex.getString("id")))).isEmpty()) {
            Map<String, Object> edgeMapWithoutID = this.asMapWithoutID(edge);
            for (String id : allEdges) {
                JsonObject existingEdge = this.getEdge(id);
                if (!edgeMapWithoutID.equals(this.asMapWithoutID(existingEdge))) continue;
                return null;
            }
        }
        EdgeImpl edgeObj = new EdgeImpl(edge.getString("id"), sourceVertex.getString("id"), destinationVertex.getString("id"), edge);
        this.edges.put(edge.getString("id"), edgeObj);
        source.getEdgesOut().add(edgeObj.getId());
        target.getEdgesIn().add(edgeObj.getId());
        return edgeId;
    }

    private String generateEdgeId() {
        String edgeId;
        do {
            edgeId = "edge::" + this.edgeGeneratorCounter;
            ++this.edgeGeneratorCounter;
        } while (this.edges.containsKey(edgeId));
        return edgeId;
    }

    @Override
    public synchronized int removeAllEdges(JsonObject sourceVertex, JsonObject destinationVertex) {
        String srcVertexId = sourceVertex.getString("id");
        String destVertexId = destinationVertex.getString("id");
        if (srcVertexId == null || destVertexId == null || !this.vertices.containsKey(srcVertexId) || !this.vertices.containsKey(destVertexId)) {
            return 0;
        }
        Vertex edgeSource = this.vertices.get(sourceVertex.getString("id"));
        Vertex edgeTarget = this.vertices.get(destinationVertex.getString("id"));
        Set<String> allEdges = this.getEdgeIdsBetween(edgeSource, edgeTarget);
        this.edges.keySet().removeAll(allEdges);
        edgeSource.getEdgesOut().removeAll(allEdges);
        edgeTarget.getEdgesIn().removeAll(allEdges);
        return allEdges.size();
    }

    @Override
    public synchronized List<JsonObject> vertexList() {
        return this.vertices.values().stream().map(Vertex::getValue).collect(Collectors.toList());
    }

    @Override
    public synchronized List<JsonObject> edgeList() {
        return this.edges.values().stream().map(Edge::getValue).collect(Collectors.toList());
    }

    @Override
    public synchronized List<JsonObject> getRootSuccessors() {
        return this.getSuccessors("root", true);
    }

    @Override
    public synchronized List<JsonObject> getSuccessors(String vertexId, boolean distinct) {
        Vertex vertex = this.vertices.get(vertexId);
        List<JsonObject> successors = vertex.getEdgesOut().stream().map(edgeId -> this.vertices.get(this.edges.get(edgeId).getDestinationVertexId())).map(Vertex::getValue).collect(Collectors.toList());
        if (distinct) {
            Set unique = Collections.newSetFromMap(new IdentityHashMap());
            successors.removeIf(v -> !unique.add(v));
        }
        return successors;
    }

    @Override
    public synchronized List<JsonObject> getPredecessors(String vertexId, boolean distinct) {
        Vertex vertex = this.vertices.get(vertexId);
        List<JsonObject> predecessors = vertex.getEdgesIn().stream().map(edgeId -> this.vertices.get(this.edges.get(edgeId).getSourceVertexId())).map(Vertex::getValue).collect(Collectors.toList());
        if (distinct) {
            Set unique = Collections.newSetFromMap(new IdentityHashMap());
            predecessors.removeIf(v -> !unique.add(v));
        }
        return predecessors;
    }

    @Override
    public synchronized List<JsonObject> getSuccessorEdges(String vertexId) {
        Vertex vertex = this.vertices.get(vertexId);
        return vertex.getEdgesOut().stream().map(edgeId -> this.edges.get(edgeId)).map(Edge::getValue).collect(Collectors.toList());
    }

    @Override
    public synchronized List<JsonObject> getPredecessorEdges(String vertexId) {
        Vertex vertex = this.vertices.get(vertexId);
        return vertex.getEdgesIn().stream().map(edgeId -> this.edges.get(edgeId)).map(Edge::getValue).collect(Collectors.toList());
    }

    @Override
    public synchronized List<JsonObject> getEdgesBetween(String vertexFromId, String vertexToId) {
        Vertex vertexFrom = this.vertices.get(vertexFromId);
        return vertexFrom.getEdgesOut().stream().map(edgeId -> this.edges.get(edgeId)).filter(edge -> edge.getDestinationVertexId().equals(vertexToId)).map(Edge::getValue).collect(Collectors.toList());
    }

    @Override
    public synchronized List<JsonObject> getEdgesBetween(JsonObject vertexFrom, JsonObject vertexTo) {
        return this.getEdgesBetween(vertexFrom.getString("id"), vertexTo.getString("id"));
    }

    private Set<String> getEdgeIdsBetween(Vertex sourceVertex, Vertex destinationVertex) {
        return sourceVertex.getEdgesOut().stream().filter(destinationVertex.getEdgesIn()::contains).collect(Collectors.toSet());
    }

    @Override
    public synchronized JsonObject getEdgeTarget(String edgeId) {
        Edge edge = this.edges.get(edgeId);
        return this.vertices.get(edge.getDestinationVertexId()).getValue();
    }

    @Override
    public synchronized JsonObject getEdgeSource(String edgeId) {
        Edge edge = this.edges.get(edgeId);
        return this.vertices.get(edge.getSourceVertexId()).getValue();
    }

    @Override
    public void clear() {
        this.vertices = new LinkedHashMap<String, Vertex>();
        this.edges = new LinkedHashMap<String, Edge>();
        JsonObject rootVertex = new JsonObject().put("id", (Object)"root").put("type", (Object)"root").put("name", (Object)"root");
        this.addVertex(rootVertex);
        this.edgeGeneratorCounter = 0;
    }

    @Override
    public synchronized JsonObject dumpGraphData(boolean deepCopy) {
        JsonObject result = new JsonObject();
        JsonObject sourceRoot = this.getVertex("root");
        result.put("modelVersion", (Object)this.graphVersion);
        result.put("root", (Object)(deepCopy ? sourceRoot.copy() : sourceRoot));
        result.put("edgeGeneratorCounter", (Object)this.edgeGeneratorCounter);
        JsonArray vertexArray = new JsonArray();
        result.put("vertexList", (Object)vertexArray);
        for (Vertex vertex : this.vertices.values()) {
            JsonObject value = vertex.getValue();
            if ("root".equals(value.getString("type"))) continue;
            vertexArray.add((Object)(deepCopy ? value.copy() : value));
        }
        JsonArray edgeArray = new JsonArray();
        result.put("edgeList", (Object)edgeArray);
        for (Edge edge : this.edges.values()) {
            JsonObject edgeResult = new JsonObject();
            edgeArray.add((Object)edgeResult);
            edgeResult.put("source", (Object)edge.getSourceVertexId());
            edgeResult.put("target", (Object)edge.getDestinationVertexId());
            edgeResult.put("edge", (Object)(deepCopy ? edge.getValue().copy() : edge.getValue()));
        }
        return result;
    }

    @Override
    public void restoreGraphData(JsonObject dump) {
        int modelVersion = dump.getInteger("modelVersion", Integer.valueOf(1));
        if (modelVersion > 3) {
            throw new IllegalArgumentException("Graph model version " + modelVersion + " not supported");
        }
        this.setGraphVersion(modelVersion);
        this.vertices = new LinkedHashMap<String, Vertex>();
        this.edges = new LinkedHashMap<String, Edge>();
        this.edgeGeneratorCounter = dump.getInteger("edgeGeneratorCounter", Integer.valueOf(0));
        JsonObject rootObj = dump.getJsonObject("root");
        if (rootObj == null) {
            throw new InvalidGraphException(this, "Missing root");
        }
        this.addVertex(rootObj);
        JsonArray vertexList = dump.getJsonArray("vertexList");
        if (vertexList == null) {
            throw new InvalidGraphException(this, "Missing vertexList");
        }
        for (Object obj : vertexList) {
            JsonObject vertexJson = (JsonObject)obj;
            if (this.addVertex(vertexJson)) continue;
            throw new InvalidGraphException(this, "Invalid or duplicate vertex: " + vertexJson.getString("id"));
        }
        JsonArray edgeList = dump.getJsonArray("edgeList");
        if (edgeList == null) {
            throw new InvalidGraphException(this, "Missing edgeList");
        }
        for (Object obj : edgeList) {
            JsonObject edgeJson = (JsonObject)obj;
            String sourceId = edgeJson.getString("source");
            String targetId = edgeJson.getString("target");
            JsonObject edge = edgeJson.getJsonObject("edge");
            if (edge == null) {
                throw new InvalidGraphException(this, "No edge object found");
            }
            Vertex sourceVertex = this.vertices.get(sourceId);
            if (sourceVertex == null) {
                throw new InvalidGraphException(this, "Invalid edge from non-existing vertex " + sourceId);
            }
            Vertex targetVertex = this.vertices.get(targetId);
            if (targetVertex == null) {
                throw new InvalidGraphException(this, "Invalid edge to non-existing vertex " + targetId);
            }
            if (this.addEdge(sourceVertex.getValue(), targetVertex.getValue(), edge) != null) continue;
            throw new InvalidGraphException(this, "Invalid or duplicate edge: " + edge.getString("id"));
        }
    }

    @Override
    public synchronized int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public synchronized int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public synchronized void printGraph() {
        this.walkAndPrint(new HashSet<Vertex>(), this.vertices.get("root"), 0);
    }

    private void walkAndPrint(Set<Vertex> stack, Vertex vertexObj, int level) {
        stack.add(vertexObj);
        System.out.println("(" + level + ") " + String.valueOf(vertexObj.getValue()));
        Set outgoingEdges = vertexObj.getEdgesOut().stream().map(edgeId -> this.edges.get(edgeId).getValue()).collect(Collectors.toSet());
        int childLevel = level + 1;
        for (JsonObject edge : outgoingEdges) {
            System.out.println("\t".repeat(level + 1) + "--> " + this.getEdgeTarget(edge.getString("id")).getString("id") + " // " + String.valueOf(edge));
            if (stack.contains(this.vertices.get(this.getEdgeTarget(edge.getString("id")).getString("id")))) {
                System.out.println("\t".repeat(level + 1) + "^^^ circular reference");
                continue;
            }
            this.walkAndPrint(stack, this.vertices.get(this.getEdgeTarget(edge.getString("id")).getString("id")), childLevel);
        }
        stack.remove(vertexObj);
    }

    private Map<String, Object> asMapWithoutID(JsonObject src) {
        if (!src.containsKey("id")) {
            return src.getMap();
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(src.getMap());
        result.remove("id");
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Graph{\n");
        buf.append("vertexList=[\n");
        for (String key : this.vertices.keySet()) {
            Vertex vertex = this.vertices.get(key);
            buf.append(" ").append(vertex).append("\n");
        }
        buf.append("],\nedgeList=[\n");
        for (String key : this.edges.keySet()) {
            Edge edge = this.edges.get(key);
            buf.append(" ").append(edge).append("\n");
        }
        buf.append("]}");
        return buf.toString();
    }

    @Override
    public GraphReport getReport() {
        return this.report;
    }

    @Override
    public void setReport(GraphReport report) {
        this.report = report;
    }

    @Override
    public int getGraphVersion() {
        return this.graphVersion;
    }

    @Override
    public void setGraphVersion(int graphVersion) {
        this.graphVersion = graphVersion;
    }
}

