/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graph.GraphClassifier;
import org.qubership.itool.modules.graph.GraphManager;
import org.qubership.itool.modules.graph.GraphService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphServiceImpl
implements GraphService {
    protected static final Logger LOG = LoggerFactory.getLogger(GraphServiceImpl.class);
    private final GraphManager graphManager;
    private final LoadingCache<GraphClassifier, Graph> graphCache;

    public GraphServiceImpl(GraphManager graphManager) {
        this(graphManager, GraphServiceImpl.defaultGraphCacheBuilder());
    }

    protected static CacheBuilder defaultGraphCacheBuilder() {
        return CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(8L).expireAfterAccess(Duration.ofDays(1L));
    }

    public GraphServiceImpl(GraphManager graphManager, CacheBuilder graphCacheBuilder) {
        this.graphManager = graphManager;
        this.graphCache = graphCacheBuilder.recordStats().build((CacheLoader)new GraphCacheLoader());
    }

    @Override
    public Graph getGraphByClassifier(GraphClassifier graphClassifier) {
        try {
            return (Graph)this.graphCache.get((Object)graphClassifier);
        }
        catch (ExecutionException e) {
            LOG.warn("Graph not found for: " + String.valueOf(graphClassifier));
            return null;
        }
    }

    @Override
    public Graph getGraphById(String graphClassifierId) {
        GraphClassifier graphClassifier = this.graphManager.resolveGraphClassifier(graphClassifierId);
        return this.getGraphByClassifier(graphClassifier);
    }

    @Override
    public void putGraph(GraphClassifier graphClassifier, Graph graph) {
        this.graphCache.put((Object)graphClassifier, (Object)graph);
    }

    @Override
    public CacheStats getGraphCacheStatitstics() {
        return this.graphCache.stats();
    }

    @Override
    public CacheStats getGraphClassifierCacheStatistics() {
        return this.graphManager.getCacheStatistics();
    }

    @Override
    public void evictCacheByGraphClassifier(GraphClassifier graphClassifier) {
        this.graphCache.invalidate((Object)graphClassifier);
        this.graphManager.invalidate(graphClassifier);
    }

    @Override
    public void evictCache() {
        this.graphCache.invalidateAll();
        this.graphManager.evictCache();
    }

    class GraphCacheLoader
    extends CacheLoader<GraphClassifier, Graph> {
        GraphCacheLoader() {
        }

        public Graph load(GraphClassifier key) throws Exception {
            Graph graph = GraphServiceImpl.this.graphManager.buildGraphByClassifier(key);
            if (graph == null) {
                throw new ExecutionException("Graph can't be loaded for: " + String.valueOf(key), new NullPointerException());
            }
            return graph;
        }
    }
}

