/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graph;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;

public class SubGraph
implements BasicGraph {
    private BasicGraph origGraph;
    private Map<String, JsonObject> edges;
    private Map<String, JsonObject> vertices;

    @Override
    public GraphTraversalSource traversal() {
        return new GraphTraversalSource(this);
    }

    public SubGraph(BasicGraph graph, List<JsonObject> edgeList) {
        this.origGraph = graph;
        this.edges = edgeList.stream().collect(Collectors.toMap(edge -> edge.getString("id"), Function.identity()));
        this.vertices = new LinkedHashMap<String, JsonObject>();
        for (JsonObject edge2 : edgeList) {
            String edgeId = edge2.getString("id");
            JsonObject edgeSource = graph.getEdgeSource(edgeId);
            this.vertices.put(edgeSource.getString("id"), edgeSource);
            JsonObject edgeTarget = graph.getEdgeTarget(edgeId);
            this.vertices.put(edgeTarget.getString("id"), edgeTarget);
        }
    }

    public void addEdge(String edgeId) {
        JsonObject vertexTarget;
        String targetId;
        JsonObject edge = this.getEdge(edgeId);
        if (edge != null) {
            return;
        }
        edge = this.origGraph.getEdge(edgeId);
        this.edges.put(edgeId, edge);
        JsonObject vertexSource = this.origGraph.getEdgeSource(edge.getString("id"));
        String sourceId = vertexSource.getString("id");
        if (this.getVertex(sourceId) == null) {
            this.vertices.put(sourceId, vertexSource);
        }
        if (this.getVertex(targetId = (vertexTarget = this.origGraph.getEdgeTarget(edge.getString("id"))).getString("id")) == null) {
            this.vertices.put(targetId, vertexTarget);
        }
    }

    @Override
    public int getVertexCount() {
        return this.vertices.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edges.size();
    }

    @Override
    public List<JsonObject> edgeList() {
        return new ArrayList<JsonObject>(this.edges.values());
    }

    @Override
    public List<JsonObject> vertexList() {
        return new ArrayList<JsonObject>(this.vertices.values());
    }

    @Override
    public JsonObject getVertex(String vertexId) {
        return this.vertices.get(vertexId);
    }

    @Override
    public JsonObject getEdge(String edgeId) {
        return this.edges.get(edgeId);
    }

    @Override
    public List<JsonObject> getSuccessors(String vertexId, boolean distinct) {
        JsonObject vertex = this.getVertex(vertexId);
        if (vertex == null) {
            return null;
        }
        List<JsonObject> successors = this.origGraph.getSuccessorEdges(vertexId).stream().filter(edge -> this.getEdge(edge.getString("id")) != null).map(edge -> this.origGraph.getEdgeTarget(edge.getString("id"))).collect(Collectors.toList());
        if (distinct) {
            Set unique = Collections.newSetFromMap(new IdentityHashMap());
            successors.removeIf(v -> !unique.add(v));
        }
        return successors;
    }

    @Override
    public List<JsonObject> getPredecessors(String vertexId, boolean distinct) {
        JsonObject vertex = this.getVertex(vertexId);
        if (vertex == null) {
            return null;
        }
        List<JsonObject> predecessors = this.origGraph.getPredecessorEdges(vertexId).stream().filter(edge -> this.getEdge(edge.getString("id")) != null).map(edge -> this.origGraph.getEdgeSource(edge.getString("id"))).collect(Collectors.toList());
        if (distinct) {
            Set unique = Collections.newSetFromMap(new IdentityHashMap());
            predecessors.removeIf(v -> !unique.add(v));
        }
        return predecessors;
    }

    @Override
    public List<JsonObject> getSuccessorEdges(String vertexId) {
        JsonObject vertex = this.getVertex(vertexId);
        if (vertex == null) {
            return null;
        }
        List<JsonObject> list = this.origGraph.getSuccessorEdges(vertexId);
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (JsonObject item : list) {
            if (this.getEdge(item.getString("id")) == null) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public List<JsonObject> getPredecessorEdges(String vertexId) {
        JsonObject vertex = this.getVertex(vertexId);
        if (vertex == null) {
            return null;
        }
        List<JsonObject> list = this.origGraph.getPredecessorEdges(vertexId);
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        for (JsonObject item : list) {
            if (this.getEdge(item.getString("id")) == null) continue;
            result.add(item);
        }
        return result;
    }

    @Override
    public List<JsonObject> getEdgesBetween(String vertexFromId, String vertexToId) {
        if (!this.vertices.containsKey(vertexFromId) || !this.vertices.containsKey(vertexToId)) {
            return Collections.emptyList();
        }
        return this.origGraph.getEdgesBetween(vertexFromId, vertexToId).stream().filter(edge -> this.getEdge(edge.getString("id")) != null).collect(Collectors.toList());
    }

    @Override
    public List<JsonObject> getEdgesBetween(JsonObject vertexFrom, JsonObject vertexTo) {
        return this.getEdgesBetween(vertexFrom.getString("id"), vertexTo.getString("id"));
    }

    @Override
    public JsonObject getEdgeTarget(String edgeId) {
        JsonObject edge = this.getEdge(edgeId);
        if (edge == null) {
            return null;
        }
        JsonObject vertex = this.origGraph.getEdgeTarget(edgeId);
        return vertex != null && this.getVertex(vertex.getString("id")) != null ? vertex : null;
    }

    @Override
    public JsonObject getEdgeSource(String edgeId) {
        JsonObject edge = this.getEdge(edgeId);
        if (edge == null) {
            return null;
        }
        JsonObject vertex = this.origGraph.getEdgeSource(edgeId);
        return vertex != null && this.getVertex(vertex.getString("id")) != null ? vertex : null;
    }
}

