/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.graphExtractor.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.graph.Graph;
import org.qubership.itool.modules.graphExtractor.AbstractGraphDataExtractor;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;
import org.qubership.itool.utils.TechNormalizationHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageAndFrameworkExtractor
extends AbstractGraphDataExtractor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(LanguageAndFrameworkExtractor.class);

    @Override
    public JsonObject getDataFromGraph(Graph graph) {
        GraphTraversalSource traversal = graph.traversal();
        JsonObject result = new JsonObject();
        List componentsWithApps = traversal.V("root").out(new String[0]).hasType("application").as("A", new String[0]).out(new String[0]).as("C", new String[0]).select("A", "C").toList();
        for (Map componentWithApp : componentsWithApps) {
            JsonObject component = (JsonObject)componentWithApp.get("C");
            List<String> languages = traversal.V(component.getString("id")).out(new String[0]).hasType("language").value("name").toList();
            List<String> frameworks = traversal.V(component.getString("id")).out(new String[0]).hasType("framework").value("name").toList();
            String componentType = component.getString("type");
            if ("component".equals(componentType)) {
                componentType = "unknown";
            }
            JsonObject componentContent = new JsonObject().put("languages", (Object)new JsonArray(TechNormalizationHelper.getTechsNames(languages))).put("frameworks", (Object)new JsonArray(TechNormalizationHelper.getTechsNames(frameworks))).put("type", (Object)componentType).put("dnsName", JsonPointer.from((String)"/details/dnsName").queryJson((Object)component)).put("applicationName", (Object)((JsonObject)componentWithApp.get("A")).getString("name"));
            result.put(component.getString("name"), (Object)componentContent);
        }
        return result;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

