/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.qubership.itool.modules.gremlin2.util.Compare;

public class P<V>
implements Predicate<V> {
    protected BiPredicate<V, V> biPredicate;
    protected V value;
    protected V originalValue;

    protected P() {
    }

    protected P(BiPredicate<V, V> biPredicate, V originalValue, V value) {
        this.biPredicate = biPredicate;
        this.value = value;
        this.originalValue = originalValue;
    }

    public P(BiPredicate<V, V> biPredicate, V value) {
        this.value = value;
        this.originalValue = value;
        this.biPredicate = biPredicate;
    }

    @Override
    public boolean test(V testValue) {
        return this.biPredicate.test(testValue, this.originalValue != null ? this.originalValue : this.value);
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public BiPredicate<V, V> getBiPredicate() {
        return this.biPredicate;
    }

    public void setBiPredicate(BiPredicate<V, V> biPredicate) {
        this.biPredicate = biPredicate;
    }

    public V getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(V originalValue) {
        this.originalValue = originalValue;
    }

    public P<V> clone() {
        P<V> clone = new P<V>(this.biPredicate, this.originalValue, this.value);
        return clone;
    }

    public static <V> P<V> eq(V value) {
        return new P<Object>(Compare.eq, value);
    }

    public static <V> P<V> neq(V value) {
        return new P<Object>(Compare.neq, value);
    }

    public static <V> P<V> within(List<V> value) {
        return new P<List<V>>(Compare.within, value);
    }

    public static <V> P<V> within(V ... values) {
        return new P<List<V>>(Compare.within, Arrays.asList(values));
    }

    public static <V> P<V> without(V ... values) {
        return new P<List<V>>(Compare.without, Arrays.asList(values));
    }

    public static <V> P<V> exists() {
        return new P<Object>(Compare.exists, null);
    }

    public static <V> P<V> isNull() {
        return new P<Object>(Compare.isNull, null);
    }

    public static <V> P<V> containing(V value) {
        return new P<Object>(Compare.containing, value);
    }

    public static <V> P<V> notContaining(V value) {
        return new P<Object>(Compare.notContaining, value);
    }

    public static <V> P<V> startingWith(V value) {
        return new P<Object>(Compare.startingWith, value);
    }

    public static <V> P<V> notStartingWith(V value) {
        return new P<Object>(Compare.notStartingWith, value);
    }

    public static <V> P<V> endingWith(V value) {
        return new P<Object>(Compare.endingWith, value);
    }

    public static <V> P<V> notEndingWith(V value) {
        return new P<Object>(Compare.notEndingWith, value);
    }

    public static <V> P<V> lt(V value) {
        return new P<Object>(Compare.lt, value);
    }

    public static <V> P<V> lte(V value) {
        return new P<Object>(Compare.lte, value);
    }

    public static <V> P<V> gt(V value) {
        return new P<Object>(Compare.gt, value);
    }

    public static <V> P<V> gte(V value) {
        return new P<Object>(Compare.gte, value);
    }

    public static <V> P<V> lteVersion(V value) {
        return new P<Object>(Compare.lteVersion, value);
    }

    public static <V> P<V> gteVersion(V value) {
        return new P<Object>(Compare.gteVersion, value);
    }

    public static <V> P<V> inside(V left, V right) {
        return new Inside<V>(left, right);
    }

    static class Inside<V>
    extends P<V> {
        private V left;
        private V right;

        public Inside(V left, V right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean test(V v) {
            P<Object> pLeft = new P<Object>(Compare.gte, this.left);
            P<Object> pRight = new P<Object>(Compare.lte, this.right);
            return pLeft.test(v) && pRight.test(v);
        }

        public String toString() {
            return "inside(" + String.valueOf(this.left) + "," + String.valueOf(this.right) + ")";
        }
    }
}

