/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.graph;

import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Path;
import org.qubership.itool.modules.gremlin2.Step;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.graph.GraphTraversalSource;
import org.qubership.itool.modules.gremlin2.graph.lambda.TrueTraversal;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.TimesModulating;
import org.qubership.itool.modules.gremlin2.step.barrier.CountGlobalStep;
import org.qubership.itool.modules.gremlin2.step.barrier.FoldStep;
import org.qubership.itool.modules.gremlin2.step.barrier.GroupStep;
import org.qubership.itool.modules.gremlin2.step.barrier.OrderStep;
import org.qubership.itool.modules.gremlin2.step.barrier.ProfileStep;
import org.qubership.itool.modules.gremlin2.step.barrier.SumStep;
import org.qubership.itool.modules.gremlin2.step.barrier.TreeStep;
import org.qubership.itool.modules.gremlin2.step.branch.ForkJoinStep;
import org.qubership.itool.modules.gremlin2.step.branch.LocalStep;
import org.qubership.itool.modules.gremlin2.step.branch.RepeatStep;
import org.qubership.itool.modules.gremlin2.step.branch.UnionStep;
import org.qubership.itool.modules.gremlin2.step.filter.DedupStep;
import org.qubership.itool.modules.gremlin2.step.filter.EmptyStep;
import org.qubership.itool.modules.gremlin2.step.filter.IsStep;
import org.qubership.itool.modules.gremlin2.step.filter.NoneStep;
import org.qubership.itool.modules.gremlin2.step.filter.NotStep;
import org.qubership.itool.modules.gremlin2.step.filter.OrStep;
import org.qubership.itool.modules.gremlin2.step.filter.RangeLimitStep;
import org.qubership.itool.modules.gremlin2.step.filter.WherePredicateStep;
import org.qubership.itool.modules.gremlin2.step.map.CapStep;
import org.qubership.itool.modules.gremlin2.step.map.SelectStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.CoalesceStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.EdgeStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.EdgeVertexStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.GlobStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.PropertyKeyStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.PropertyValueStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.SplitStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.UnfoldStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.VertexStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.IdStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.MapToVertexStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.NameStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.PathStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.SelectScalarStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.SizeStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.TypeStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.ValueMapStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.ValueReplaceStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.ValueStep;
import org.qubership.itool.modules.gremlin2.step.sideEffect.SubgraphStep;
import org.qubership.itool.modules.gremlin2.step.util.HasContainer;
import org.qubership.itool.modules.gremlin2.step.util.Profile;
import org.qubership.itool.modules.gremlin2.step.util.Tree;
import org.qubership.itool.modules.gremlin2.structure.Direction;
import org.qubership.itool.modules.gremlin2.structure.MapElement;
import org.qubership.itool.modules.gremlin2.util.Order;
import org.qubership.itool.modules.gremlin2.util.TraversalHelper;

public interface GraphTraversal<S, E>
extends Traversal<S, E> {
    default public Profile profile() {
        this.asAdmin().addStep((Step)new ProfileStep(this.asAdmin()));
        return (Profile)this.next();
    }

    default public GraphTraversal<S, E> none() {
        return this.asAdmin().addStep((Step)new NoneStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> empty() {
        return this.asAdmin().addStep((Step)new EmptyStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> local(Traversal<?, E2> localTraversal) {
        return this.asAdmin().addStep((Step)new LocalStep(this.asAdmin(), localTraversal.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> fork(Traversal<?, E2> forkedTraversal) {
        return this.fork(ForkJoinPool.commonPool(), forkedTraversal);
    }

    default public <E2> GraphTraversal<S, E2> fork(ForkJoinPool pool, Traversal<?, E2> forkedTraversal) {
        return this.asAdmin().addStep((Step)new ForkJoinStep(this.asAdmin(), forkedTraversal, pool));
    }

    default public GraphTraversal<S, E> mapToVertex() {
        return this.asAdmin().addStep((Step)new MapToVertexStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> hasId(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer("id", idList.size() == 1 ? P.eq(idList.get(0)) : P.within(idList))));
    }

    default public GraphTraversal<S, E> hasNotId(String ... ids) {
        for (String id : ids) {
            TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer("id", P.neq(id)));
        }
        return this;
    }

    default public GraphTraversal<S, E> hasKey(String ... keys) {
        for (String key : keys) {
            TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(key, P.exists()));
        }
        return this;
    }

    default public GraphTraversal<S, E> hasKeys(String ... keys) {
        return this.hasKey(keys);
    }

    default public GraphTraversal<S, E> hasNot(String ... keys) {
        for (String key : keys) {
            TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(key, P.isNull()));
        }
        return this;
    }

    default public GraphTraversal<S, E> hasType(String ... types) {
        List<String> typeList = Arrays.asList(types);
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer("type", typeList.size() == 1 ? P.eq(typeList.get(0)) : P.within(typeList))));
    }

    default public GraphTraversal<S, E> hasTypes(String ... types) {
        return this.hasType(types);
    }

    default public GraphTraversal<S, E> has(String type, String propertyKey, String value) {
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), type, new HasContainer(propertyKey, P.eq(value))));
    }

    default public GraphTraversal<S, E> has(String type, String propertyKey, P<?> predicate) {
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), type, new HasContainer(propertyKey, predicate)));
    }

    default public GraphTraversal<S, E> has(String propertyKey, String value) {
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, P.eq(value))));
    }

    default public GraphTraversal<S, E> has(String propertyKey, P<?> predicate) {
        return (GraphTraversal)((Object)TraversalHelper.addHasContainer(this.asAdmin(), new HasContainer(propertyKey, predicate)));
    }

    default public GraphTraversal<S, String> id() {
        return this.asAdmin().addStep((Step)new IdStep(this.asAdmin()));
    }

    default public GraphTraversal<S, String> type() {
        return this.asAdmin().addStep((Step)new TypeStep(this.asAdmin()));
    }

    default public GraphTraversal<S, String> name() {
        return this.asAdmin().addStep((Step)new NameStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> key() {
        return this.asAdmin().addStep((Step)new PropertyKeyStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> value() {
        return this.asAdmin().addStep((Step)new PropertyValueStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> valueReplace(String regex, String replacement) {
        return this.asAdmin().addStep((Step)new ValueReplaceStep(this.asAdmin(), regex, replacement));
    }

    default public GraphTraversal<S, Integer> size() {
        return this.asAdmin().addStep((Step)new SizeStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Tree> tree() {
        return this.asAdmin().addStep((Step)new TreeStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> as(String stepLabel, String ... stepLabels) {
        Step endStep = this.asAdmin().getEndStep();
        endStep.addLabel(stepLabel);
        for (String label : stepLabels) {
            endStep.addLabel(label);
        }
        return this;
    }

    default public <E> GraphTraversal<S, E> select(String selectKey) {
        Traversal.Admin sMapAdmin = this.asAdmin().addStep((Step)new SelectScalarStep(this.asAdmin(), selectKey));
        return (GraphTraversal)((Object)sMapAdmin);
    }

    default public <E> GraphTraversal<S, E> cap(String sideEffectKey) {
        Traversal.Admin sMapAdmin = this.asAdmin().addStep((Step)new CapStep(this.asAdmin(), sideEffectKey));
        return (GraphTraversal)((Object)sMapAdmin);
    }

    default public <E2> GraphTraversal<S, Map<String, E2>> select(String ... selectKeys) {
        Traversal.Admin sMapAdmin = this.asAdmin().addStep((Step)new SelectStep(this.asAdmin(), selectKeys));
        return (GraphTraversal)((Object)sMapAdmin);
    }

    default public GraphTraversal<S, Path> path() {
        return this.asAdmin().addStep((Step)new PathStep(this.asAdmin()));
    }

    default public GraphTraversal<S, JsonObject> out(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new VertexStep(this.asAdmin(), Direction.OUT, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> in(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new VertexStep(this.asAdmin(), Direction.IN, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> both(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new VertexStep(this.asAdmin(), Direction.BOTH, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> outE(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new EdgeStep(this.asAdmin(), Direction.OUT, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> inE(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new EdgeStep(this.asAdmin(), Direction.IN, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> bothE(String ... edgeLabels) {
        return this.asAdmin().addStep((Step)new EdgeStep(this.asAdmin(), Direction.BOTH, edgeLabels));
    }

    default public GraphTraversal<S, JsonObject> inV() {
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.IN));
    }

    default public GraphTraversal<S, JsonObject> outV() {
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.OUT));
    }

    default public GraphTraversal<S, JsonObject> bothV() {
        return this.asAdmin().addStep((Step)new EdgeVertexStep(this.asAdmin(), Direction.BOTH));
    }

    default public <E2> GraphTraversal<S, E2> value(String propertyKey) {
        return this.asAdmin().addStep((Step)new ValueStep(this.asAdmin(), propertyKey));
    }

    default public <E2> GraphTraversal<S, Map<Object, E2>> values(String ... propertyKeys) {
        return this.asAdmin().addStep((Step)new ValueMapStep(this.asAdmin(), propertyKeys));
    }

    default public GraphTraversal<S, Long> count() {
        return this.asAdmin().addStep((Step)new CountGlobalStep(this.asAdmin()));
    }

    default public GraphTraversal<S, Float> sum() {
        return this.asAdmin().addStep((Step)new SumStep(this.asAdmin()));
    }

    default public <K, V> GraphTraversal<S, Map<K, V>> group() {
        return this.asAdmin().addStep((Step)new GroupStep(this.asAdmin()));
    }

    default public GraphTraversal<S, E> by(String string) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(string);
        return this;
    }

    default public GraphTraversal<S, E> by(String ... args) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(args);
        return this;
    }

    default public GraphTraversal<S, E> by(MapElement mapElement) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(mapElement);
        return this;
    }

    default public GraphTraversal<S, E> by(Traversal traversal) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(traversal);
        return this;
    }

    default public GraphTraversal<S, E> by(Order order) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(order);
        return this;
    }

    default public GraphTraversal<S, E> by(String propertyKey, Order order) {
        Step endStep = this.asAdmin().getEndStep();
        if (!(endStep instanceof ByModulating)) {
            throw new UnsupportedOperationException("Step " + endStep.getClass().getSimpleName() + " not supported .by() modulation");
        }
        ByModulating byModulating = (ByModulating)((Object)endStep);
        byModulating.modulateBy(propertyKey, order);
        return this;
    }

    default public <E2> GraphTraversal<S, E2> coalesce(Traversal<?, E2> ... coalesceTraversals) {
        return this.asAdmin().addStep((Step)new CoalesceStep(this.asAdmin(), (Traversal.Admin[])Arrays.copyOf(coalesceTraversals, coalesceTraversals.length, Traversal.Admin[].class)));
    }

    default public GraphTraversal<S, E> is(Object value) {
        return this.asAdmin().addStep(new IsStep<Object>(this.asAdmin(), value instanceof P ? (P<Object>)value : P.eq(value)));
    }

    default public GraphTraversal<S, E> where(String startKey, P<String> predicate) {
        return this.asAdmin().addStep((Step)new WherePredicateStep(this.asAdmin(), Optional.ofNullable(startKey), predicate));
    }

    default public GraphTraversal<S, E> where(P<String> predicate) {
        return this.asAdmin().addStep((Step)new WherePredicateStep(this.asAdmin(), Optional.empty(), predicate));
    }

    default public GraphTraversal<S, E> where(Traversal<?, ?> innerTraversal) {
        return this.asAdmin().addStep((Step)new WherePredicateStep(this.asAdmin(), innerTraversal));
    }

    default public GraphTraversal<S, E> dedup() {
        return this.asAdmin().addStep((Step)new DedupStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> union(Traversal<?, E2> ... unionTraversals) {
        return this.asAdmin().addStep((Step)new UnionStep(this.asAdmin(), (Traversal.Admin[])Arrays.copyOf(unionTraversals, unionTraversals.length, Traversal.Admin[].class)));
    }

    default public GraphTraversal<S, E> not(Traversal<?, ?> innerTraversal) {
        return this.asAdmin().addStep((Step)new NotStep(this.asAdmin(), innerTraversal));
    }

    default public <E2> GraphTraversal<S, E2> or(Traversal<?, E2> ... orTraversals) {
        return this.asAdmin().addStep((Step)new OrStep(this.asAdmin(), (Traversal.Admin[])Arrays.copyOf(orTraversals, orTraversals.length, Traversal.Admin[].class)));
    }

    default public GraphTraversal<S, E> range(int rangeFrom, int rangeTo) {
        return this.asAdmin().addStep((Step)new RangeLimitStep(this.asAdmin(), Optional.of(rangeFrom), Optional.of(rangeTo)));
    }

    default public GraphTraversal<S, E> limit(int limit) {
        return this.asAdmin().addStep((Step)new RangeLimitStep(this.asAdmin(), Optional.empty(), Optional.of(limit)));
    }

    default public GraphTraversal<S, E> tail(int rangeFrom) {
        return this.asAdmin().addStep((Step)new RangeLimitStep(this.asAdmin(), Optional.of(rangeFrom), Optional.empty()));
    }

    default public GraphTraversal<S, E> order() {
        return this.asAdmin().addStep((Step)new OrderStep(this.asAdmin()));
    }

    default public <E2 extends String> GraphTraversal<String, String> split() {
        return this.asAdmin().addStep((Step)new SplitStep(this.asAdmin()));
    }

    default public <E2> GraphTraversal<S, E2> unfold() {
        return this.asAdmin().addStep((Step)new UnfoldStep(this.asAdmin()));
    }

    default public GraphTraversal<S, List<E>> fold() {
        return this.asAdmin().addStep((Step)new FoldStep(this.asAdmin()));
    }

    default public GraphTraversal<S, JsonObject> subgraph(String sideEffectKey) {
        return this.asAdmin().addStep((Step)new SubgraphStep(this.asAdmin(), sideEffectKey));
    }

    default public GraphTraversal<S, E> repeat(Traversal<?, E> repeatTraversal) {
        return RepeatStep.addRepeatToTraversal(this, (Traversal.Admin)repeatTraversal);
    }

    default public GraphTraversal<S, E> times(int maxLoops) {
        if (this.asAdmin().getEndStep() instanceof TimesModulating) {
            ((TimesModulating)((Object)this.asAdmin().getEndStep())).modulateTimes(maxLoops);
            return this;
        }
        throw new IllegalStateException("times() modulator supported only for TimesModulating implementations");
    }

    default public GraphTraversal<S, E> until(Traversal<?, ?> untilTraversal) {
        return RepeatStep.addUntilToTraversal(this, (Traversal.Admin)untilTraversal);
    }

    default public GraphTraversal<S, E> emit() {
        return RepeatStep.addEmitToTraversal(this, TrueTraversal.instance());
    }

    default public GraphTraversal<S, E> emit(Traversal<?, ?> emitTraversal) {
        return RepeatStep.addEmitToTraversal(this, (Traversal.Admin)emitTraversal);
    }

    default public GraphTraversal<S, JsonObject> glob(String pattern) {
        return this.asAdmin().addStep((Step)new GlobStep(this.asAdmin(), pattern));
    }

    @Override
    public Admin<S, E> clone();

    @Override
    default public Admin<S, E> asAdmin() {
        return (Admin)this;
    }

    public static interface Admin<S, E>
    extends Traversal.Admin<S, E>,
    GraphTraversal<S, E> {
        @Override
        default public <E2> Admin<S, E2> addStep(Step<?, E2> step) {
            return (Admin)Traversal.Admin.super.addStep(step);
        }

        @Override
        public Admin<S, E> clone();

        public GraphTraversalSource getSource();

        public void setSource(GraphTraversalSource var1);
    }
}

