/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.DefaultTraverser;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.util.ElementType;

public class GraphStep<S, E extends JsonObject>
extends AbstractStep<S, E> {
    protected String[] ids;
    protected boolean isStart;
    protected Class<E> returnClass;
    protected Supplier<Iterator<S>> iteratorSupplier;
    protected ElementType elementType;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this.elementType) + "," + Arrays.toString(this.ids) + ")";
    }

    public GraphStep(Traversal.Admin traversal, Class<E> returnClass, boolean isStart, ElementType elementType, String ... ids) {
        super(traversal);
        this.returnClass = returnClass;
        this.isStart = isStart;
        this.elementType = elementType;
        this.ids = ids;
        switch (this.elementType) {
            case vertex: {
                this.iteratorSupplier = () -> ids.length == 0 ? this.getTraversal().getGraph().vertexList().iterator() : this.getVerticesByIds().iterator();
                break;
            }
            case edge: {
                this.iteratorSupplier = () -> ids.length == 0 ? this.getTraversal().getGraph().edgeList().iterator() : this.getEdgesByIds().iterator();
            }
        }
    }

    private List<JsonObject> getVerticesByIds() {
        BasicGraph g = this.getTraversal().getGraph();
        ArrayList<JsonObject> result = new ArrayList<JsonObject>(this.ids.length);
        for (String id : this.ids) {
            JsonObject v = g.getVertex(id);
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    private List<JsonObject> getEdgesByIds() {
        BasicGraph g = this.getTraversal().getGraph();
        ArrayList<JsonObject> result = new ArrayList<JsonObject>(this.ids.length);
        for (String id : this.ids) {
            JsonObject e = g.getEdge(id);
            if (e == null) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    protected List<Traverser<S>> fetchPreviousTraversers() {
        ArrayList<Traverser<S>> result = new ArrayList<Traverser<S>>();
        Iterator<S> iterator = this.iteratorSupplier.get();
        while (iterator.hasNext()) {
            S item = iterator.next();
            DefaultTraverser<S> traverser = new DefaultTraverser<S>((JsonObject)item, item);
            result.add(traverser);
        }
        return result;
    }

    @Override
    protected void processPreviousTraverser(Traverser.Admin<S> previousTraverser, List<Traverser<E>> result) {
        result.add(previousTraverser);
    }

    @Override
    public GraphStep<S, E> clone() {
        GraphStep clone = (GraphStep)super.clone();
        clone.isStart = this.isStart;
        clone.returnClass = this.returnClass;
        clone.elementType = this.elementType;
        clone.ids = this.ids;
        return clone;
    }
}

