/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.barrier;

import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.barrier.ReducingBarrierStep;
import org.qubership.itool.modules.gremlin2.structure.MapElement;
import org.qubership.itool.modules.gremlin2.util.Order;

public class OrderStep<S, E>
extends ReducingBarrierStep<S, S>
implements ByModulating {
    private Order orderBy = Order.asc;
    private String orderByKey;
    private MapElement orderByMapElement;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.orderBy == null ? "" : this.orderBy) + (this.orderByKey == null ? "" : this.orderByKey) + String.valueOf(this.orderByMapElement == null ? "" : this.orderByMapElement) + ")";
    }

    public OrderStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected void processAllPreviousTraversers(List<Traverser<S>> previousTraversers, List<Traverser<S>> result) {
        result.addAll(previousTraversers);
        if (this.orderByKey != null) {
            Collections.sort(result, (first, second) -> {
                Object secondObj;
                Object firstObj = first == null ? null : first.get();
                Object v0 = secondObj = second == null ? null : second.get();
                if (firstObj == null && secondObj == null) {
                    return 0;
                }
                if (firstObj == null) {
                    return -1;
                }
                if (secondObj == null) {
                    return 1;
                }
                Object firstValue = null;
                Object secondValue = null;
                if (firstObj instanceof JsonObject) {
                    firstValue = ((JsonObject)firstObj).getValue(this.orderByKey);
                } else if (firstObj instanceof Map) {
                    firstValue = ((Map)firstObj).get(this.orderByKey);
                }
                if (secondObj instanceof JsonObject) {
                    secondValue = ((JsonObject)secondObj).getValue(this.orderByKey);
                } else if (firstObj instanceof Map) {
                    secondValue = ((Map)secondObj).get(this.orderByKey);
                }
                if (firstValue == null && secondValue == null) {
                    return 0;
                }
                if (firstValue == null) {
                    return -1;
                }
                if (secondValue == null) {
                    return 1;
                }
                return this.orderBy.compare(firstValue, secondValue);
            });
        } else if (this.orderByMapElement != null) {
            Collections.sort(result, (first, second) -> {
                Object secondObj;
                Object firstObj = first == null ? null : (Object)first.get();
                Object t = secondObj = second == null ? null : (Object)second.get();
                if (firstObj == null && secondObj == null) {
                    return 0;
                }
                if (firstObj == null) {
                    return -1;
                }
                if (secondObj == null) {
                    return 1;
                }
                Object firstValue = null;
                Object secondValue = null;
                if (firstObj instanceof Map && secondObj instanceof Map) {
                    switch (this.orderByMapElement) {
                        case key: {
                            firstValue = ((Map)firstObj).keySet().iterator().next();
                            secondValue = ((Map)secondObj).keySet().iterator().next();
                            break;
                        }
                        case value: {
                            firstValue = ((Map)firstObj).values().iterator().next();
                            secondValue = ((Map)secondObj).values().iterator().next();
                            break;
                        }
                    }
                } else {
                    firstValue = firstObj;
                    secondValue = secondObj;
                }
                if (firstValue == null && secondValue == null) {
                    return 0;
                }
                if (firstValue == null) {
                    return -1;
                }
                if (secondValue == null) {
                    return 1;
                }
                return this.orderBy.compare(firstValue, secondValue);
            });
        } else {
            Collections.sort(result, this.orderBy);
        }
    }

    @Override
    protected S projectTraversers(List<Traverser<S>> previousTraversers) {
        return null;
    }

    @Override
    public void modulateBy(Order order) throws UnsupportedOperationException {
        this.orderBy = order;
    }

    @Override
    public void modulateBy(String propertyKey, Order order) throws UnsupportedOperationException {
        this.orderBy = order;
        this.orderByKey = propertyKey;
    }

    @Override
    public void modulateBy(String string) throws UnsupportedOperationException {
        this.orderByKey = string;
    }

    @Override
    public void modulateBy(MapElement mapElement) throws UnsupportedOperationException {
        this.orderByMapElement = mapElement;
    }

    @Override
    public AbstractStep<S, S> clone() {
        OrderStep clone = (OrderStep)super.clone();
        clone.orderBy = this.orderBy;
        return clone;
    }
}

