/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.filter;

import java.util.Optional;
import org.qubership.itool.modules.gremlin2.P;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.filter.FilterStep;

public class WherePredicateStep<S>
extends FilterStep<S>
implements ByModulating {
    protected String startKey;
    protected P<Object> predicate;
    protected Traversal.Admin<?, ?> innerTraversal;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.startKey + "," + String.valueOf(this.predicate) + (this.innerTraversal == null ? "" : ",traversal") + ")";
    }

    @Override
    public void clear() {
        this.clearTraversal(this.innerTraversal);
    }

    public WherePredicateStep(Traversal.Admin traversal, Optional<String> startKey, P<String> predicate) {
        super(traversal);
        this.startKey = startKey.orElse(null);
        this.predicate = predicate;
    }

    public WherePredicateStep(Traversal.Admin traversal, Traversal<?, ?> innerTraversal) {
        super(traversal);
        this.innerTraversal = innerTraversal.asAdmin();
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.predicate != null) {
            return this.filterByPredicate(traverser);
        }
        if (this.innerTraversal != null) {
            return this.filterByTraversal(traverser);
        }
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " required predicate or traversal");
    }

    private boolean filterByTraversal(Traverser.Admin<S> traverser) {
        Traversal.Admin<?, ?> cloneTraversal = this.prepareInnerTraversal(this.innerTraversal, traverser);
        Object result = cloneTraversal.next();
        return result != null;
    }

    private boolean filterByPredicate(Traverser.Admin<S> traverser) {
        Object clonePredicate = this.predicate.clone();
        if (this.startKey == null) {
            String origPredicateValue = (String)((P)clonePredicate).getValue();
            Object predicateObject = traverser.path().get(origPredicateValue);
            ((P)clonePredicate).setOriginalValue(predicateObject);
        }
        return ((P)clonePredicate).test(traverser.get());
    }

    @Override
    public AbstractStep<S, S> clone() {
        WherePredicateStep clone = (WherePredicateStep)super.clone();
        clone.startKey = this.startKey;
        clone.predicate = this.predicate != null ? this.predicate.clone() : null;
        clone.innerTraversal = this.innerTraversal != null ? this.innerTraversal.clone() : null;
        return clone;
    }
}

