/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.flat;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.FlatMapStep;
import org.qubership.itool.modules.gremlin2.structure.Direction;

public class EdgeVertexStep<E extends JsonObject>
extends FlatMapStep<JsonObject, JsonObject> {
    protected Direction direction;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this.direction) + ")";
    }

    public EdgeVertexStep(Traversal.Admin traversal, Direction direction) {
        super(traversal);
        this.direction = direction;
    }

    @Override
    protected Traverser<JsonObject> generateTraverser(Traverser.Admin<JsonObject> previousTraverser, JsonObject value) {
        Traverser.Admin<JsonObject> traverser = previousTraverser.split(value, value, this);
        return traverser;
    }

    @Override
    protected List<JsonObject> flatMap(Traverser.Admin<JsonObject> traverser) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        BasicGraph graph = this.traversal.getGraph();
        JsonObject edge = null;
        if (graph != null && (edge = traverser.getSource()) == null) {
            edge = (JsonObject)traverser.get();
        }
        if (edge == null || graph.getEdge(edge.getString("id")) != edge) {
            throw new GremlinException(this.getClass().getSimpleName() + " applicable only to Edge");
        }
        switch (this.direction) {
            case OUT: {
                result.add(graph.getEdgeSource(edge.getString("id")));
                break;
            }
            case IN: {
                result.add(graph.getEdgeTarget(edge.getString("id")));
                break;
            }
            case BOTH: {
                result.add(graph.getEdgeSource(edge.getString("id")));
                result.add(graph.getEdgeTarget(edge.getString("id")));
            }
        }
        return result;
    }

    @Override
    public AbstractStep<JsonObject, JsonObject> clone() {
        EdgeVertexStep clone = (EdgeVertexStep)super.clone();
        clone.direction = this.direction;
        return clone;
    }
}

