/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.flat;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.DefaultTraverser;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.ByModulating;
import org.qubership.itool.modules.gremlin2.step.map.flat.FlatMapStep;

public class GlobStep
extends FlatMapStep<JsonObject, JsonObject>
implements ByModulating {
    private static final String BY_DEFAULT = "name";
    public static final String GLOB_DELIMETER = "/";
    private String pattern;
    private List<Object> patternList;
    private String byProperty;
    private Traversal<?, ?> byTraversal;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.pattern + ")";
    }

    public GlobStep(Traversal.Admin traversal, String pattern) {
        super(traversal);
        this.pattern = pattern;
        String[] rawPatternArray = this.pattern.split(GLOB_DELIMETER);
        this.patternList = new ArrayList<Object>(rawPatternArray.length);
        for (String patternElement : rawPatternArray) {
            if (patternElement.isEmpty()) continue;
            if ("**".equals(patternElement)) {
                if (this.patternList.size() != 0 && "**".equals(this.patternList.get(this.patternList.size() - 1))) continue;
                this.patternList.add(patternElement);
                continue;
            }
            if (patternElement.contains("*") || patternElement.contains("?")) {
                String regex = "^" + patternElement.replaceAll("\\.", "\\\\.").replaceAll("\\*", "\\.*").replaceAll("\\?", "\\.") + "$";
                Pattern regexPattern = Pattern.compile(regex);
                this.patternList.add(regexPattern);
                continue;
            }
            this.patternList.add(patternElement);
        }
    }

    @Override
    protected List<JsonObject> flatMap(Traverser.Admin<JsonObject> traverser) {
        ArrayList<JsonObject> result = new ArrayList<JsonObject>();
        JsonObject sourceVertex = this.requireSourceVertex(traverser);
        this.patternMatching(sourceVertex, result, this.patternList, true);
        return result;
    }

    private void patternMatching(JsonObject source, List<JsonObject> result, List<Object> patterns, boolean letDoubleWildcard) {
        block8: {
            List<Object> patternsTail;
            Object patternElement;
            String value;
            block9: {
                block7: {
                    if (patterns.isEmpty()) {
                        return;
                    }
                    String by = this.byProperty == null ? BY_DEFAULT : this.byProperty;
                    value = source.getString(by);
                    if (value == null) {
                        return;
                    }
                    patternElement = patterns.get(0);
                    patternsTail = patterns.subList(1, patterns.size());
                    if (!"**".equals(patternElement)) break block7;
                    if (letDoubleWildcard) {
                        this.addVertexIfLast(source, result, patterns);
                        this.patternMatching(source, result, patternsTail, true);
                    }
                    List<JsonObject> successors = this.fetchSuccessors(source);
                    for (JsonObject successor : successors) {
                        this.patternMatching(successor, result, patterns, patterns.size() == 1);
                        this.patternMatching(successor, result, patternsTail, true);
                    }
                    break block8;
                }
                if (!(patternElement instanceof Pattern)) break block9;
                Pattern regexPattern = (Pattern)patternElement;
                if (!regexPattern.matcher(value.toString()).matches()) break block8;
                this.addVertexIfLast(source, result, patterns);
                List<JsonObject> successors = this.fetchSuccessors(source);
                for (JsonObject successor : successors) {
                    this.patternMatching(successor, result, patternsTail, true);
                }
                break block8;
            }
            if (patternElement.equals(value)) {
                this.addVertexIfLast(source, result, patterns);
                List<JsonObject> successors = this.fetchSuccessors(source);
                for (JsonObject successor : successors) {
                    this.patternMatching(successor, result, patternsTail, true);
                }
            }
        }
    }

    private void addVertexIfLast(JsonObject sourceVertex, List<JsonObject> result, List<Object> patterns) {
        if (patterns.size() == 1) {
            result.add(sourceVertex);
        }
    }

    private List<JsonObject> fetchSuccessors(JsonObject sourceVertex) {
        if (this.byTraversal != null) {
            ArrayList trList = new ArrayList();
            trList.add(new DefaultTraverser<JsonObject>(sourceVertex, sourceVertex));
            Traversal.Admin cloneTraversal = this.prepareInnerTraversal((Traversal.Admin)this.byTraversal, trList);
            return cloneTraversal.toList();
        }
        BasicGraph graph = this.traversal.getGraph();
        return graph.getSuccessors(sourceVertex.getString("id"), true);
    }

    @Override
    public void modulateBy(String byProperty) throws UnsupportedOperationException {
        this.byProperty = byProperty;
    }

    @Override
    public void modulateBy(Traversal traversal) throws UnsupportedOperationException {
        this.byTraversal = traversal;
    }

    @Override
    public void clear() {
        this.clearTraversal((Traversal.Admin)this.byTraversal);
    }

    @Override
    public AbstractStep<JsonObject, JsonObject> clone() {
        GlobStep clone = (GlobStep)super.clone();
        clone.pattern = this.pattern;
        clone.byProperty = this.byProperty;
        clone.byTraversal = this.byTraversal;
        return clone;
    }
}

