/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.flat;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.map.flat.FlatMapStep;
import org.qubership.itool.modules.gremlin2.structure.Direction;

public class VertexStep<E extends JsonObject>
extends FlatMapStep<JsonObject, E> {
    private String[] edgeLabels;
    private Direction direction;

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf((Object)this.direction) + "," + String.valueOf(Arrays.asList(this.edgeLabels)) + ")";
    }

    public VertexStep(Traversal.Admin traversal, Direction direction, String ... edgeLabels) {
        super(traversal);
        this.direction = direction;
        this.edgeLabels = edgeLabels;
    }

    @Override
    protected List<E> flatMap(Traverser.Admin<JsonObject> traverser) {
        ArrayList result = new ArrayList();
        BasicGraph graph = this.traversal.getGraph();
        JsonObject sourceVertex = this.requireSourceVertex(traverser);
        switch (this.direction) {
            case OUT: {
                this.fillResult(graph.getSuccessorEdges(sourceVertex.getString("id")), result, edge -> graph.getEdgeTarget(edge.getString("id")));
                break;
            }
            case IN: {
                this.fillResult(graph.getPredecessorEdges(sourceVertex.getString("id")), result, edge -> graph.getEdgeSource(edge.getString("id")));
                break;
            }
            case BOTH: {
                this.fillResult(graph.getSuccessorEdges(sourceVertex.getString("id")), result, edge -> graph.getEdgeTarget(edge.getString("id")));
                this.fillResult(graph.getPredecessorEdges(sourceVertex.getString("id")), result, edge -> graph.getEdgeSource(edge.getString("id")));
            }
        }
        return result;
    }

    @Override
    protected Traverser<E> generateTraverser(Traverser.Admin<JsonObject> previousTraverser, E value) {
        Traverser.Admin<E> traverser = previousTraverser.split((JsonObject)value, value, this);
        return traverser;
    }

    private void fillResult(List<JsonObject> edges, List<E> result, Function<JsonObject, JsonObject> fn) {
        for (JsonObject edge : edges) {
            if (this.edgeLabels.length == 0) {
                JsonObject vertex = fn.apply(edge);
                result.add(vertex);
            }
            for (String type : this.edgeLabels) {
                if (!type.equals(edge.getString("type"))) continue;
                JsonObject vertex = fn.apply(edge);
                result.add(vertex);
            }
        }
    }

    @Override
    public AbstractStep<JsonObject, E> clone() {
        VertexStep clone = (VertexStep)super.clone();
        clone.edgeLabels = this.edgeLabels;
        clone.direction = this.direction;
        return clone;
    }
}

