/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.map.scalar;

import io.vertx.core.json.JsonObject;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.gremlin2.Path;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.map.scalar.ScalarMapStep;

public class SelectScalarStep<S, E>
extends ScalarMapStep<S, E> {
    private String label;

    @Override
    public String toString() {
        return super.toString() + (String)(this.label == null ? "" : "(" + this.label + ")");
    }

    public SelectScalarStep(Traversal.Admin traversal, String label) {
        super(traversal);
        this.label = label;
    }

    @Override
    protected E map(Traverser.Admin<S> previousTraverser) {
        Path path = previousTraverser.path();
        return (E)path.get(this.label);
    }

    @Override
    public AbstractStep<S, E> clone() {
        SelectScalarStep clone = (SelectScalarStep)super.clone();
        clone.label = this.label;
        return clone;
    }

    @Override
    protected Traverser<E> generateTraverser(Traverser.Admin<S> previousTraverser, E value) {
        JsonObject asJson;
        String id;
        BasicGraph graph = this.traversal.getGraph();
        JsonObject newSource = null;
        if (graph != null && value instanceof JsonObject && (graph.getVertex(id = (asJson = (JsonObject)value).getString("id")) == asJson || graph.getEdge(id) == asJson)) {
            newSource = asJson;
        }
        Traverser.Admin<E> traverser = previousTraverser.split(newSource, value, this);
        return traverser;
    }
}

