/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.step.sideEffect;

import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import org.qubership.itool.modules.graph.BasicGraph;
import org.qubership.itool.modules.graph.SubGraph;
import org.qubership.itool.modules.gremlin2.GremlinException;
import org.qubership.itool.modules.gremlin2.Traversal;
import org.qubership.itool.modules.gremlin2.Traverser;
import org.qubership.itool.modules.gremlin2.step.AbstractStep;
import org.qubership.itool.modules.gremlin2.step.sideEffect.SideEffectStep;

public class SubgraphStep
extends SideEffectStep<JsonObject> {
    protected String sideEffectKey;

    public SubgraphStep(Traversal.Admin traversal, String sideEffectKey) {
        super(traversal);
        this.sideEffectKey = sideEffectKey;
    }

    @Override
    protected void sideEffect(Traverser.Admin<JsonObject> traverser) {
        JsonObject edge;
        Traversal.Admin rootTraversal = this.fetchRootTraversal();
        BasicGraph graph = this.traversal.getGraph();
        SubGraph subGraph = (SubGraph)rootTraversal.getSideEffect(this.sideEffectKey);
        if (subGraph == null) {
            subGraph = new SubGraph(graph, new ArrayList<JsonObject>());
            rootTraversal.addSideEffect(this.sideEffectKey, subGraph);
        }
        if ((edge = (JsonObject)traverser.get()) == null || graph.getEdge(edge.getString("id")) != edge) {
            throw new GremlinException(this.getClass().getSimpleName() + " applicable only to Edge");
        }
        subGraph.addEdge(edge.getString("id"));
    }

    @Override
    public AbstractStep<JsonObject, JsonObject> clone() {
        SubgraphStep clone = (SubgraphStep)super.clone();
        clone.sideEffectKey = this.sideEffectKey;
        return clone;
    }
}

