/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.gremlin2.util;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Compare implements BiPredicate<Object, Object>
{
    eq{

        @Override
        public boolean test(Object first, Object second) {
            if (null == first) {
                return null == second;
            }
            if (1.bothAreNumber(first, second)) {
                return 1.compareNumber((Number)first, (Number)second) == 0;
            }
            if (second instanceof List) {
                List list = (List)second;
                if (list.size() == 1) {
                    return list.get(0).equals(first);
                }
                return false;
            }
            return first.equals(second);
        }

        public Compare negate() {
            return neq;
        }
    }
    ,
    neq{

        @Override
        public boolean test(Object first, Object second) {
            return !eq.test(first, second);
        }

        public Compare negate() {
            return eq;
        }
    }
    ,
    lt{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (3.bothAreNumber(first, second) ? 3.compareNumber((Number)first, (Number)second) < 0 : first.equals(second));
        }

        public Compare negate() {
            return gte;
        }
    }
    ,
    lte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (4.bothAreNumber(first, second) ? 4.compareNumber((Number)first, (Number)second) <= 0 : first.equals(second));
        }

        public Compare negate() {
            return gt;
        }
    }
    ,
    gt{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (5.bothAreNumber(first, second) ? 5.compareNumber((Number)first, (Number)second) > 0 : first.equals(second));
        }

        public Compare negate() {
            return lte;
        }
    }
    ,
    gte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (6.bothAreNumber(first, second) ? 6.compareNumber((Number)first, (Number)second) >= 0 : first.equals(second));
        }

        public Compare negate() {
            return lt;
        }
    }
    ,
    lteVersion{

        @Override
        public boolean test(Object first, Object second) {
            if (!7.bothAreVersion(first, second)) {
                return false;
            }
            String firstVersion = (String)first;
            String secondVersion = (String)second;
            Matcher firstMatcher = versionPattern.matcher(firstVersion);
            Matcher secondMatcher = versionPattern.matcher(secondVersion);
            firstMatcher.matches();
            secondMatcher.matches();
            int firstGroupCount = firstMatcher.groupCount();
            int secondGroupCount = secondMatcher.groupCount();
            int groupCount = firstGroupCount >= secondGroupCount ? firstGroupCount : secondGroupCount;
            for (int i = 1; i < groupCount; ++i) {
                int secondValue;
                int firstValue;
                if (firstMatcher.group(i) == null || secondMatcher.group(i) == null || (firstValue = Integer.parseInt(firstMatcher.group(i))) == (secondValue = Integer.parseInt(secondMatcher.group(i)))) continue;
                return secondValue > firstValue;
            }
            return true;
        }

        public Compare negate() {
            return gteVersion;
        }
    }
    ,
    gteVersion{

        @Override
        public boolean test(Object first, Object second) {
            if (!8.bothAreVersion(first, second)) {
                return false;
            }
            String firstVersion = (String)first;
            String secondVersion = (String)second;
            Matcher firstMatcher = versionPattern.matcher(firstVersion);
            Matcher secondMatcher = versionPattern.matcher(secondVersion);
            firstMatcher.matches();
            secondMatcher.matches();
            int firstGroupCount = firstMatcher.groupCount();
            int secondGroupCount = secondMatcher.groupCount();
            int groupCount = firstGroupCount >= secondGroupCount ? firstGroupCount : secondGroupCount;
            for (int i = 1; i < groupCount; ++i) {
                int secondValue;
                int firstValue = Integer.parseInt(firstMatcher.group(i));
                if (firstValue == (secondValue = Integer.parseInt(secondMatcher.group(i)))) continue;
                return secondValue < firstValue;
            }
            return true;
        }

        public Compare negate() {
            return lteVersion;
        }
    }
    ,
    within{

        @Override
        public boolean test(Object first, Object second) {
            if (second instanceof List) {
                List secondList = (List)second;
                return secondList.contains(first);
            }
            return false;
        }

        public Compare negate() {
            return without;
        }
    }
    ,
    without{

        @Override
        public boolean test(Object first, Object second) {
            if (second instanceof List) {
                List secondList = (List)second;
                return !secondList.contains(first);
            }
            return false;
        }

        public Compare negate() {
            return within;
        }
    }
    ,
    exists{

        @Override
        public boolean test(Object first, Object second) {
            return first != null;
        }

        public Compare negate() {
            return isNull;
        }
    }
    ,
    isNull{

        @Override
        public boolean test(Object first, Object second) {
            return first == null;
        }

        public Compare negate() {
            return exists;
        }
    }
    ,
    containing{

        @Override
        public boolean test(Object first, Object second) {
            if (13.bothAreString(first, second)) {
                return ((String)first).contains((String)second);
            }
            if (first instanceof JsonArray) {
                return ((JsonArray)first).contains(second);
            }
            return false;
        }

        public Compare negate() {
            return notContaining;
        }
    }
    ,
    notContaining{

        @Override
        public boolean test(Object first, Object second) {
            if (14.bothAreString(first, second)) {
                return !((String)first).contains((String)second);
            }
            if (first instanceof JsonArray) {
                return !((JsonArray)first).contains(second);
            }
            return false;
        }

        public Compare negate() {
            return containing;
        }
    }
    ,
    startingWith{

        @Override
        public boolean test(Object first, Object second) {
            if (15.bothAreString(first, second)) {
                return ((String)first).startsWith((String)second);
            }
            return false;
        }

        public Compare negate() {
            return notStartingWith;
        }
    }
    ,
    notStartingWith{

        @Override
        public boolean test(Object first, Object second) {
            if (16.bothAreString(first, second)) {
                return !((String)first).startsWith((String)second);
            }
            return false;
        }

        public Compare negate() {
            return startingWith;
        }
    }
    ,
    endingWith{

        @Override
        public boolean test(Object first, Object second) {
            if (17.bothAreString(first, second)) {
                return ((String)first).endsWith((String)second);
            }
            return false;
        }

        public Compare negate() {
            return notEndingWith;
        }
    }
    ,
    notEndingWith{

        @Override
        public boolean test(Object first, Object second) {
            if (18.bothAreString(first, second)) {
                return !((String)first).endsWith((String)second);
            }
            return false;
        }

        public Compare negate() {
            return endingWith;
        }
    };

    private static final Pattern versionPattern;

    public static int compareNumber(Number first, Number second) {
        long secondLong;
        long firstLong = first.longValue();
        if (firstLong == (secondLong = second.longValue())) {
            return 0;
        }
        if (firstLong > secondLong) {
            return 1;
        }
        return -1;
    }

    public static boolean bothAreVersion(Object first, Object second) {
        return Compare.isVersion(first) && Compare.isVersion(second);
    }

    public static boolean bothAreNumber(Object first, Object second) {
        return Compare.isNumber(first) && Compare.isNumber(second);
    }

    public static boolean bothAreString(Object first, Object second) {
        return Compare.isString(first) && Compare.isString(second);
    }

    public static boolean isString(Object obj) {
        return obj instanceof String;
    }

    public static boolean isNumber(Object number) {
        if (number instanceof Integer) {
            return true;
        }
        return number instanceof Long;
    }

    public static boolean isVersion(Object version) {
        if (!(version instanceof String)) {
            return false;
        }
        String ver = (String)version;
        return versionPattern.matcher(ver).matches();
    }

    public static boolean bothAreJsonObject(Object first, Object second) {
        return first instanceof JsonObject && second instanceof JsonObject;
    }

    public static int compareJsonObject(JsonObject first, JsonObject second) {
        return first.getString("id").compareTo(second.getString("id"));
    }

    static {
        versionPattern = Pattern.compile("^\\D*(\\d+)(?:[\\._](\\d+))?(?:[\\._](\\d+))?(?:[\\._](\\d+))?.*$");
    }
}

