/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.itool.modules.parsing;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.qubership.itool.modules.report.GraphReport;
import org.qubership.itool.utils.JsonUtils;
import org.qubership.itool.utils.LanguageUtils;

public class InventoryJsonParser {
    GraphReport report;

    @Inject
    public InventoryJsonParser(GraphReport report) {
        this.report = report;
    }

    public InventoryJsonParser() {
    }

    public void parse(JsonObject domain, JsonObject component, String inventorySource) {
        this.parse(domain, component, new JsonObject(inventorySource));
    }

    public void parse(JsonObject domain, JsonObject component, JsonObject inventoryJson) {
        this.fillDetails(domain, component, inventoryJson);
        this.fillFeatures(component, inventoryJson);
    }

    private void fillDetails(JsonObject domain, JsonObject component, JsonObject inventoryJson) {
        JsonObject detailsJson = JsonUtils.getOrCreateJsonObject(component, "details");
        String abbreviation = inventoryJson.getString("id");
        detailsJson.put("abbreviation", (Object)abbreviation);
        component.put("abbreviation", (Object)abbreviation);
        String name = inventoryJson.getString("name");
        detailsJson.put("name", (Object)name);
        component.put("name", (Object)name);
        String owner = inventoryJson.getString("owner");
        JsonUtils.putValueIfNotNull(detailsJson, "owner", owner);
        String dnsName = inventoryJson.getString("dnsName");
        JsonArray altDnsNames = inventoryJson.getJsonArray("altDnsNames");
        InventoryJsonParser.fillDnsNames(detailsJson, dnsName, altDnsNames);
        String domainFromInventory = inventoryJson.getString("domain");
        JsonUtils.putValueIfNotNull(detailsJson, "domainFromInventory", domainFromInventory);
        detailsJson.put("domain", domain.getValue("id"));
        String description = inventoryJson.getString("description");
        JsonUtils.putValueIfNotNull(detailsJson, "description", description);
        String type = inventoryJson.getString("type");
        JsonUtils.putValueIfNotNull(detailsJson, "type", type);
        JsonUtils.putValueIfNotNull(component, "type", type);
        Object framework = inventoryJson.getValue("framework");
        JsonUtils.putValueIfNotNull(detailsJson, "framework", JsonUtils.convertListToFilteredString(framework));
        JsonArray documentation = inventoryJson.getJsonArray("documentation");
        JsonUtils.putValueIfNotNull(detailsJson, "documentationLink", documentation);
        Object tmfSpec = inventoryJson.getValue("tmfSpec");
        if (tmfSpec != null) {
            if (tmfSpec instanceof JsonObject) {
                detailsJson.put("tmfSpec", (Object)InventoryJsonParser.convertToLegacyTmfSpec((JsonObject)tmfSpec));
            } else {
                this.report.addMessage("CONF_ERROR", component, component.getString("id") + ": TMF Spec has wrong type mentioned- " + String.valueOf(tmfSpec.getClass()));
            }
        }
        Object language = inventoryJson.getValue("language");
        JsonUtils.putValueIfNotNull(detailsJson, "language", LanguageUtils.convertListToLanguages(language));
        this.fillApiDocumentation(detailsJson, inventoryJson);
        this.processDatabases(detailsJson, inventoryJson);
        this.processQueues(detailsJson, inventoryJson);
        JsonObject dependency = inventoryJson.getJsonObject("dependency");
        JsonUtils.putValueIfNotNull(detailsJson, "dependencies", dependency);
        JsonUtils.copyValueIfNotNull(inventoryJson, detailsJson, "thirdparty");
    }

    private static void fillDnsNames(JsonObject detailsJson, String dnsName, JsonArray altDnsNames) {
        JsonArray dnsNames = new JsonArray();
        if (dnsName != null) {
            detailsJson.put("dnsName", (Object)dnsName);
            dnsNames.add((Object)dnsName);
        }
        if (altDnsNames != null) {
            dnsNames.addAll(altDnsNames);
        }
        detailsJson.put("dnsNames", (Object)dnsNames);
    }

    private void fillApiDocumentation(JsonObject details, JsonObject inventoryJson) {
        Object apisp;
        JsonObject apiJson = new JsonObject();
        details.put("api", (Object)apiJson);
        Boolean openApi = inventoryJson.getBoolean("openApi", Boolean.valueOf(false));
        if (openApi != null) {
            apiJson.put("openApi", (Object)(openApi != false ? "yes" : "no"));
        }
        if ((apisp = inventoryJson.getValue("openAPIpublished")) instanceof JsonArray) {
            JsonArray apiSpecPublished = (JsonArray)apisp;
            apiJson.put("apiSpecPublished", (Object)apiSpecPublished);
        } else if (apisp instanceof String) {
            JsonArray apiSpecPublished = new JsonArray().add(apisp);
            apiJson.put("apiSpecPublished", (Object)apiSpecPublished);
        }
    }

    private void processDatabases(JsonObject details, JsonObject inventoryJson) {
        JsonArray source = inventoryJson.getJsonArray("database");
        if (source == null) {
            return;
        }
        JsonArray target = JsonUtils.getOrCreateJsonArray(details, JsonPointer.from((String)"/database/database"));
        for (Object o : source) {
            JsonObject jo = JsonUtils.asJsonObject(o);
            Object name = jo.getString("name");
            String version = jo.getString("version");
            if (StringUtils.isNotEmpty((CharSequence)version)) {
                name = (String)name + " " + version;
            }
            JsonObject dbItem = new JsonObject().put("item", name).put("viaZookeeper", (Object)"no");
            target.add((Object)dbItem);
        }
    }

    private void processQueues(JsonObject details, JsonObject inventoryJson) {
        JsonArray source = inventoryJson.getJsonArray("queue");
        if (source == null) {
            return;
        }
        JsonObject target = JsonUtils.getOrCreateJsonObject(details, "messageQueues");
        for (Object o : source) {
            JsonObject jo = (JsonObject)o;
            String type = jo.getString("type", "").toLowerCase();
            if ("rabbitmq".equals(type)) {
                type = "rabbitMQ";
            }
            String role = jo.getString("role", "consumer");
            String qName = jo.getString("name", "");
            JsonObject qtype = JsonUtils.getOrCreateJsonObject(target, type);
            JsonUtils.getOrCreateJsonArray(qtype, role).add((Object)qName);
        }
    }

    private void fillFeatures(JsonObject component, JsonObject inventoryJson) {
        JsonObject featuresJson = new JsonObject();
        component.put("features", (Object)featuresJson);
        this.parseFeaturesMultitenancy(featuresJson, inventoryJson);
    }

    private void parseFeaturesMultitenancy(JsonObject featuresJson, JsonObject inventoryJson) {
        JsonObject multitenancyJson = new JsonObject();
        featuresJson.put("multitenancy", (Object)multitenancyJson);
        String defaultTenantId = (Boolean)JsonPointer.from((String)"/multitenancy/defaultTenantId").queryJsonOrDefault((Object)inventoryJson, (Object)Boolean.FALSE) != false ? "yes" : "no";
        multitenancyJson.put("defaultTenantId", (Object)defaultTenantId);
    }

    private static JsonArray convertToLegacyTmfSpec(JsonObject spec) {
        JsonArray result = new JsonArray();
        for (Map.Entry item : spec.getMap().entrySet()) {
            String tmfSpecNumber = (String)item.getKey();
            for (String tmfSpecVersion : InventoryJsonParser.getVersions(new JsonObject((Map)item.getValue()))) {
                result.add((Object)(tmfSpecNumber + " v" + tmfSpecVersion));
            }
        }
        return result;
    }

    private static List<String> getVersions(JsonObject version) {
        if (version == null) {
            return Collections.emptyList();
        }
        Object tmfSpecVersions = version.getValue("version");
        if (tmfSpecVersions == null) {
            return Collections.emptyList();
        }
        if (tmfSpecVersions instanceof JsonArray) {
            return ((JsonArray)tmfSpecVersions).getList();
        }
        if (tmfSpecVersions instanceof String) {
            return Collections.singletonList((String)tmfSpecVersions);
        }
        return Collections.singletonList(version.getString("version"));
    }
}

